/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;

public class Stat
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter LS_TIME_FORMAT = DateTimeFormatter.ofPattern("MMM dd HH:mm");
    private final EnumSet<StatAttribute> _definedAttrs = EnumSet.noneOf(StatAttribute.class);
    public static final int S_TYPE = 258048;
    public static final int S_PERMS = 511;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    private int _dev;
    private long _ino;
    private int _mode;
    private int _nlink;
    private int _owner;
    private int _group;
    private int _rdev;
    private long _size;
    private long _generation;
    private long _atime;
    private long _mtime;
    private long _ctime;
    private long _btime;
    private static final String[] SIZE_UNITS = new String[]{"", "K", "M", "G", "T", "P", "E", "Z", "Y"};

    public int getDev() {
        this.guard(StatAttribute.DEV);
        return this._dev;
    }

    public void setDev(int dev) {
        this.define(StatAttribute.DEV);
        this._dev = dev;
    }

    public long getIno() {
        this.guard(StatAttribute.INO);
        return this._ino;
    }

    public void setIno(long ino) {
        this.define(StatAttribute.INO);
        this._ino = ino;
    }

    public int getMode() {
        this.guard(StatAttribute.MODE);
        return this._mode;
    }

    public void setMode(int mode) {
        this.define(StatAttribute.MODE);
        this._mode = mode;
    }

    public int getNlink() {
        this.guard(StatAttribute.NLINK);
        return this._nlink;
    }

    public void setNlink(int nlink) {
        this.define(StatAttribute.NLINK);
        this._nlink = nlink;
    }

    public int getUid() {
        this.guard(StatAttribute.OWNER);
        return this._owner;
    }

    public void setUid(int owner) {
        this.define(StatAttribute.OWNER);
        this._owner = owner;
    }

    public int getGid() {
        this.guard(StatAttribute.GROUP);
        return this._group;
    }

    public void setGid(int group) {
        this.define(StatAttribute.GROUP);
        this._group = group;
    }

    public int getRdev() {
        this.guard(StatAttribute.RDEV);
        return this._rdev;
    }

    public void setRdev(int rdev) {
        this.define(StatAttribute.RDEV);
        this._rdev = rdev;
    }

    public long getSize() {
        this.guard(StatAttribute.SIZE);
        return this._size;
    }

    public void setSize(long size) {
        this.define(StatAttribute.SIZE);
        this._size = size;
    }

    public long getATime() {
        this.guard(StatAttribute.ATIME);
        return this._atime;
    }

    public void setATime(long atime) {
        this.define(StatAttribute.ATIME);
        this._atime = atime;
    }

    public long getMTime() {
        this.guard(StatAttribute.MTIME);
        return this._mtime;
    }

    public void setMTime(long mtime) {
        this.define(StatAttribute.MTIME);
        this._mtime = mtime;
    }

    public long getCTime() {
        this.guard(StatAttribute.CTIME);
        return this._ctime;
    }

    public void setCTime(long ctime) {
        this.define(StatAttribute.CTIME);
        this._ctime = ctime;
    }

    public long getBTime() {
        this.guard(StatAttribute.BTIME);
        return this._btime;
    }

    public void setBTime(long btime) {
        this.define(StatAttribute.BTIME);
        this._btime = btime;
    }

    public long getGeneration() {
        this.guard(StatAttribute.GENERATION);
        return this._generation;
    }

    public void setGeneration(long generation) {
        this.define(StatAttribute.GENERATION);
        this._generation = generation;
    }

    public Type type() {
        this.guard(StatAttribute.MODE);
        return Type.fromMode(this._mode);
    }

    public static String modeToString(int mode) {
        StringBuilder result = new StringBuilder(10);
        switch (Type.fromMode(mode)) {
            case BLOCK: {
                result.append("b");
                break;
            }
            case CHAR: {
                result.append("c");
                break;
            }
            case DIRECTORY: {
                result.append("d");
                break;
            }
            case FIFO: {
                result.append("p");
                break;
            }
            case SOCK: {
                result.append("s");
                break;
            }
            case SYMLINK: {
                result.append("l");
                break;
            }
            default: {
                result.append("-");
            }
        }
        block18: for (int i = 0; i < 3; ++i) {
            int acl = mode >> 6 - 3 * i & 7;
            switch (acl) {
                case 0: {
                    result.append("---");
                    continue block18;
                }
                case 1: {
                    result.append("--x");
                    continue block18;
                }
                case 2: {
                    result.append("-w-");
                    continue block18;
                }
                case 3: {
                    result.append("-wx");
                    continue block18;
                }
                case 4: {
                    result.append("r--");
                    continue block18;
                }
                case 5: {
                    result.append("r-x");
                    continue block18;
                }
                case 6: {
                    result.append("rw-");
                    continue block18;
                }
                case 7: {
                    result.append("rwx");
                }
            }
        }
        return result.toString();
    }

    public static String sizeToString(long bytes) {
        if (bytes == 0L) {
            return "0";
        }
        int orderOfMagnitude = (int)Math.floor(Math.log(bytes) / Math.log(1024.0));
        double significantSize = (double)bytes / (double)(1L << orderOfMagnitude * 10);
        DecimalFormat sizeFormat = new DecimalFormat("#.#");
        return sizeFormat.format(significantSize) + SIZE_UNITS[orderOfMagnitude];
    }

    public Stat clone() {
        try {
            return (Stat)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        String humanReadableSize = Stat.sizeToString(this._size);
        String humanReadableMTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this._mtime), ZoneId.systemDefault()).format(LS_TIME_FORMAT);
        return Stat.modeToString(this._mode) + " " + String.format("%4d %4d %4d %4s %s", this._nlink, this._owner, this._group, humanReadableSize, humanReadableMTime);
    }

    public boolean isDefined(StatAttribute attr) {
        return this._definedAttrs.contains((Object)attr);
    }

    public void undefine(StatAttribute attr) {
        this._definedAttrs.remove((Object)attr);
    }

    private void guard(StatAttribute attr) throws IllegalStateException {
        if (!this.isDefined(attr)) {
            throw new IllegalStateException("Attribute is not defined: " + attr);
        }
    }

    private void define(StatAttribute attr) {
        this._definedAttrs.add(attr);
    }

    public static enum StatAttribute {
        DEV,
        INO,
        MODE,
        NLINK,
        OWNER,
        GROUP,
        RDEV,
        SIZE,
        GENERATION,
        ATIME,
        MTIME,
        CTIME,
        BTIME;

    }

    public static enum Type {
        LEGACY,
        REGULAR,
        DIRECTORY,
        SYMLINK,
        CHAR,
        BLOCK,
        FIFO,
        SOCK;


        public int toMode() {
            switch (this) {
                case REGULAR: {
                    return 32768;
                }
                case DIRECTORY: {
                    return 16384;
                }
                case SYMLINK: {
                    return 40960;
                }
                case CHAR: {
                    return 8192;
                }
                case BLOCK: {
                    return 24576;
                }
                case FIFO: {
                    return 4096;
                }
                case SOCK: {
                    return 49152;
                }
            }
            throw new IllegalArgumentException("unhandled: " + this);
        }

        public static Type fromMode(int mode) {
            switch (mode & 0x3F000) {
                case 32768: {
                    return REGULAR;
                }
                case 16384: {
                    return DIRECTORY;
                }
                case 40960: {
                    return SYMLINK;
                }
                case 8192: {
                    return CHAR;
                }
                case 24576: {
                    return BLOCK;
                }
                case 4096: {
                    return FIFO;
                }
                case 49152: {
                    return SOCK;
                }
            }
            return REGULAR;
        }
    }
}

