/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.vfs;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.nfs.util.GuavaCacheMXBeanImpl;
import org.dcache.nfs.util.Opaque;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.ForwardingFileSystem;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VfsCacheConfig;
import org.dcache.nfs.vfs.VirtualFileSystem;

public class VfsCache
extends ForwardingFileSystem {
    private final LoadingCache<CacheKey, Inode> _lookupCache;
    private final Cache<Opaque, Stat> _statCache;
    private final LoadingCache<Inode, Inode> _parentCache;
    private final Supplier<FsStat> _fsStatSupplier;
    private final Cache<InodeCacheEntry, DirectoryStream> _readdirCache;
    private final VirtualFileSystem _inner;

    public VfsCache(VirtualFileSystem inner, VfsCacheConfig cacheConfig) {
        this._inner = inner;
        this._lookupCache = CacheBuilder.newBuilder().maximumSize(cacheConfig.getMaxEntries()).expireAfterWrite(cacheConfig.getLifeTime(), cacheConfig.getTimeUnit()).softValues().recordStats().build(new LoockupLoader());
        this._statCache = CacheBuilder.newBuilder().maximumSize(cacheConfig.getMaxEntries()).expireAfterWrite(cacheConfig.getLifeTime(), cacheConfig.getTimeUnit()).softValues().recordStats().build();
        this._parentCache = CacheBuilder.newBuilder().maximumSize(cacheConfig.getMaxEntries()).expireAfterWrite(100L, TimeUnit.MILLISECONDS).softValues().recordStats().build(new ParentLoader());
        this._readdirCache = CacheBuilder.newBuilder().maximumSize(cacheConfig.getReaddirMaxEntries()).expireAfterWrite(cacheConfig.getReaddirLifeTime(), cacheConfig.getReaddirLifeTimeUnit()).softValues().recordStats().build();
        this._fsStatSupplier = cacheConfig.getFsStatLifeTime() > 0L ? Suppliers.memoizeWithExpiration(new FsStatSupplier(), cacheConfig.getFsStatLifeTime(), cacheConfig.getFsSataTimeUnit()) : new FsStatSupplier();
        new GuavaCacheMXBeanImpl("vfs-stat", this._statCache);
        new GuavaCacheMXBeanImpl("vfs-parent", this._parentCache);
        new GuavaCacheMXBeanImpl("vfs-lookup", this._lookupCache);
        new GuavaCacheMXBeanImpl("vfs-readdir", this._readdirCache);
    }

    @Override
    protected VirtualFileSystem delegate() {
        return this._inner;
    }

    @Override
    public void commit(Inode inode, long offset, int count) throws IOException {
        this.invalidateStatCache(inode);
        this._inner.commit(inode, offset, count);
    }

    @Override
    public Inode symlink(Inode parent, String path, String link, Subject subject, int mode) throws IOException {
        Inode inode = this._inner.symlink(parent, path, link, subject, mode);
        this.invalidateStatCache(parent);
        return inode;
    }

    @Override
    public void remove(Inode parent, String path) throws IOException {
        Inode inode = this.lookup(parent, path);
        this._inner.remove(parent, path);
        this.invalidateLookupCache(parent, path);
        this.invalidateStatCache(parent);
        this.invalidateStatCache(inode);
    }

    @Override
    public Inode parentOf(Inode inode) throws IOException {
        return this.parentFromCacheOrLoad(inode);
    }

    @Override
    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        boolean isChanged = this._inner.move(src, oldName, dest, newName);
        if (isChanged) {
            this.invalidateLookupCache(src, oldName);
            this.invalidateLookupCache(dest, newName);
            this.invalidateStatCache(src);
            this.invalidateStatCache(dest);
        }
        return isChanged;
    }

    @Override
    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        Inode inode = this._inner.mkdir(parent, path, subject, mode);
        this.updateLookupCache(parent, path, inode);
        this.invalidateStatCache(parent);
        return inode;
    }

    @Override
    public Inode link(Inode parent, Inode link, String path, Subject subject) throws IOException {
        Inode inode = this._inner.link(parent, link, path, subject);
        this.updateLookupCache(parent, path, inode);
        this.invalidateStatCache(parent);
        this.invalidateStatCache(inode);
        return inode;
    }

    @Override
    public Inode lookup(Inode parent, String path) throws IOException {
        return this.lookupFromCacheOrLoad(parent, path);
    }

    @Override
    public FsStat getFsStat() throws IOException {
        return this._fsStatSupplier.get();
    }

    @Override
    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        Inode inode = this._inner.create(parent, type, path, subject, mode);
        this.updateLookupCache(parent, path, inode);
        this.invalidateStatCache(parent);
        this.updateParentCache(inode, parent);
        return inode;
    }

    @Override
    public Stat getattr(Inode inode) throws IOException {
        return this.statFromCacheOrLoad(inode);
    }

    @Override
    public void setattr(Inode inode, Stat stat) throws IOException {
        this._inner.setattr(inode, stat);
        this.invalidateStatCache(inode);
    }

    @Override
    public boolean getCaseInsensitive() {
        return this._inner.getCaseInsensitive();
    }

    @Override
    public boolean getCasePreserving() {
        return this._inner.getCasePreserving();
    }

    public void invalidateLookupCache(Inode parent, String path) {
        this._lookupCache.invalidate(new CacheKey(parent, path));
    }

    private void updateLookupCache(Inode parent, String path, Inode inode) {
        this._lookupCache.put(new CacheKey(parent, path), inode);
    }

    public void invalidateStatCache(Inode inode) {
        this._statCache.invalidate(new Opaque(inode.getFileId()));
    }

    private void updateParentCache(Inode inode, Inode parent) {
        this._parentCache.put(inode, parent);
    }

    private Inode lookupFromCacheOrLoad(Inode parent, String path) throws IOException {
        try {
            return this._lookupCache.get(new CacheKey(parent, path));
        }
        catch (ExecutionException e) {
            Throwable t2 = e.getCause();
            Throwables.throwIfInstanceOf(t2, IOException.class);
            throw new IOException(e.getMessage(), t2);
        }
    }

    private Stat statFromCacheOrLoad(Inode inode) throws IOException {
        try {
            return this._statCache.get(new Opaque(inode.getFileId()), () -> this._inner.getattr(inode));
        }
        catch (ExecutionException e) {
            Throwable t2 = e.getCause();
            Throwables.throwIfInstanceOf(t2, IOException.class);
            throw new IOException(e.getMessage(), t2);
        }
    }

    private Inode parentFromCacheOrLoad(Inode inode) throws IOException {
        try {
            return this._parentCache.get(inode);
        }
        catch (ExecutionException e) {
            Throwable t2 = e.getCause();
            Throwables.throwIfInstanceOf(t2, IOException.class);
            throw new IOException(e.getMessage(), t2);
        }
    }

    @Override
    public DirectoryStream list(Inode inode, byte[] verifier, long cookie) throws IOException {
        InodeCacheEntry cacheKey = cookie == 0L && Arrays.equals(verifier, DirectoryStream.ZERO_VERIFIER) ? new InodeCacheEntry(inode, this.delegate().directoryVerifier(inode)) : new InodeCacheEntry(inode, verifier);
        DirectoryStream directoryStream = this._readdirCache.getIfPresent(cacheKey);
        if (directoryStream == null) {
            directoryStream = this.delegate().list(inode, DirectoryStream.ZERO_VERIFIER, 0L);
            cacheKey = new InodeCacheEntry(inode, directoryStream.getVerifier());
            this._readdirCache.put(cacheKey, directoryStream);
        }
        return directoryStream.tail(cookie);
    }

    @Override
    public void removeXattr(Inode inode, String attr) throws IOException {
        this._inner.removeXattr(inode, attr);
        this.invalidateStatCache(inode);
    }

    @Override
    public void setXattr(Inode inode, String attr, byte[] value, VirtualFileSystem.SetXattrMode mode) throws IOException {
        this._inner.setXattr(inode, attr, value, mode);
        this.invalidateStatCache(inode);
    }

    private class LoockupLoader
    extends CacheLoader<CacheKey, Inode> {
        private LoockupLoader() {
        }

        @Override
        public Inode load(CacheKey k) throws Exception {
            return VfsCache.this._inner.lookup(k.getParent(), k.getName());
        }
    }

    private class ParentLoader
    extends CacheLoader<Inode, Inode> {
        private ParentLoader() {
        }

        @Override
        public Inode load(Inode inode) throws Exception {
            return VfsCache.this._inner.parentOf(inode);
        }
    }

    private class FsStatSupplier
    implements Supplier<FsStat> {
        private FsStatSupplier() {
        }

        @Override
        public FsStat get() {
            try {
                return VfsCache.this._inner.getFsStat();
            }
            catch (IOException e) {
                return new FsStat(0L, 0L, 0L, 0L);
            }
        }
    }

    private static class CacheKey {
        private final Inode _parent;
        private final String _name;

        public CacheKey(Inode parent, String name2) {
            this._parent = parent;
            this._name = name2;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return other._parent.equals(this._parent) & other._name.equals(this._name);
        }

        public int hashCode() {
            return Objects.hash(this._name, this._parent);
        }

        public String getName() {
            return this._name;
        }

        public Inode getParent() {
            return this._parent;
        }
    }

    private static class InodeCacheEntry {
        private final Inode _inode;
        private final byte[] _verifier;

        public InodeCacheEntry(Inode inode, byte[] verifier) {
            this._inode = Objects.requireNonNull(inode);
            this._verifier = Objects.requireNonNull(verifier);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            InodeCacheEntry other = (InodeCacheEntry)obj;
            return this._inode.equals(other._inode) && Arrays.equals(this._verifier, other._verifier);
        }

        public int hashCode() {
            return this._inode.hashCode() ^ Arrays.hashCode(this._verifier);
        }
    }
}

