/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.grizzly;

import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.nio.channels.CompletionHandler;
import java.util.Objects;
import org.dcache.oncrpc4j.grizzly.StartTlsFilter;
import org.dcache.oncrpc4j.rpc.ReplyQueue;
import org.dcache.oncrpc4j.rpc.RpcAuthError;
import org.dcache.oncrpc4j.rpc.RpcAuthException;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.memory.BuffersBuffer;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyRpcTransport
implements RpcTransport {
    private final Connection<InetSocketAddress> _connection;
    private final ReplyQueue _replyQueue;
    private final InetSocketAddress _localAddress;
    private final InetSocketAddress _remoteAddress;
    private final boolean _isStreaming;
    private static final Logger _log = LoggerFactory.getLogger(GrizzlyRpcTransport.class);

    public GrizzlyRpcTransport(Connection<InetSocketAddress> connection, ReplyQueue replyQueue) {
        this(connection, connection.getPeerAddress(), replyQueue);
    }

    public GrizzlyRpcTransport(Connection<InetSocketAddress> connection, InetSocketAddress remoteAddress, ReplyQueue replyQueue) {
        this._connection = connection;
        this._replyQueue = replyQueue;
        this._localAddress = this._connection.getLocalAddress();
        this._remoteAddress = remoteAddress;
        this._isStreaming = connection.getTransport() instanceof TCPNIOTransport;
    }

    @Override
    public boolean isOpen() {
        return this._connection.isOpen();
    }

    @Override
    public <A> void send(Xdr xdr, final A attachment, final CompletionHandler<Integer, ? super A> handler) {
        Objects.requireNonNull(handler, "CompletionHandler can't be null");
        Buffer buffer = xdr.asBuffer();
        if (this._isStreaming) {
            int len = buffer.remaining() | Integer.MIN_VALUE;
            Object marker = this._connection.getMemoryManager().allocate(4);
            marker.order(ByteOrder.BIG_ENDIAN);
            marker.putInt(len);
            marker.flip();
            buffer = BuffersBuffer.create(this._connection.getMemoryManager(), new Buffer[]{marker, buffer});
        }
        this._connection.write(this._remoteAddress, buffer, new EmptyCompletionHandler<WriteResult<WritableMessage, InetSocketAddress>>(){

            @Override
            public void failed(Throwable throwable) {
                handler.failed(throwable, attachment);
            }

            @Override
            public void completed(WriteResult<WritableMessage, InetSocketAddress> result) {
                handler.completed((int)result.getWrittenSize(), attachment);
            }
        });
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this._localAddress;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this._remoteAddress;
    }

    @Override
    public ReplyQueue getReplyQueue() {
        return this._replyQueue;
    }

    @Override
    public RpcTransport getPeerTransport() {
        return new GrizzlyRpcTransport(this._connection, this.getReplyQueue());
    }

    public String toString() {
        return this.getRemoteSocketAddress() + " <=> " + this.getLocalSocketAddress();
    }

    @Override
    public void startTLS() throws RpcAuthException {
        FilterChain currentChain = (FilterChain)this._connection.getProcessor();
        if (currentChain.indexOfType(SSLFilter.class) >= 0) {
            throw new IllegalStateException("TLS is already enabled.");
        }
        currentChain.stream().filter(StartTlsFilter.class::isInstance).findAny().map(StartTlsFilter.class::cast).orElseThrow(() -> new RpcAuthException("SSL is not configured", new RpcAuthError(7))).startTLS(this._connection);
    }

    @Override
    public boolean isTLS() {
        return ((FilterChain)this._connection.getProcessor()).stream().filter(SSLFilter.class::isInstance).findAny().isPresent();
    }
}

