/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.grizzly;

import com.google.common.annotations.Beta;
import java.io.IOException;
import javax.net.ssl.SSLEngine;
import org.dcache.oncrpc4j.rpc.RpcAuthError;
import org.dcache.oncrpc4j.rpc.RpcAuthException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class StartTlsFilter
extends BaseFilter {
    private static final Object STARTTLS_FLAG = new Object();
    private static final String STARTTLS_ATTR_NAME = StartTlsFilter.class + ".connection-starttls";
    private static final Attribute<Object> STARTTLS_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(STARTTLS_ATTR_NAME);
    private static final Logger LOGGER = LoggerFactory.getLogger(StartTlsFilter.class);
    private final SSLFilter sslFilter;
    private final boolean isClient;

    public StartTlsFilter(SSLFilter sslFilter, boolean isClient) {
        this.sslFilter = sslFilter;
        this.isClient = isClient;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        NextAction nextAction = super.handleWrite(ctx);
        Connection connection = ctx.getConnection();
        if (STARTTLS_ATTR.isSet(connection)) {
            this.enableSSLFilter(connection);
        }
        return nextAction;
    }

    public void startTLS(Connection connection) throws RpcAuthException {
        if (this.isClient) {
            this.enableSSLFilter(connection);
            try {
                this.sslFilter.handshake(connection, new EmptyCompletionHandler<SSLEngine>());
            }
            catch (IOException e) {
                LOGGER.error("Failed to perform TLS handshake: {}", (Object)e.getMessage());
                throw new RpcAuthException("Failed to perform TLS handshake", new RpcAuthError(7));
            }
        } else {
            STARTTLS_ATTR.set(connection, STARTTLS_FLAG);
        }
    }

    private void enableSSLFilter(Connection connection) {
        FilterChain currentChain = (FilterChain)connection.getProcessor();
        FilterChainBuilder chainBuilder = FilterChainBuilder.stateless().addAll(currentChain).remove(this).add(1, this.sslFilter);
        connection.setProcessor(chainBuilder.build());
    }
}

