/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.portmap;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.dcache.oncrpc4j.portmap.OncPortmapClient;
import org.dcache.oncrpc4j.portmap.PortmapV2Client;
import org.dcache.oncrpc4j.portmap.RpcbindV4Client;
import org.dcache.oncrpc4j.portmap.rpcb;
import org.dcache.oncrpc4j.rpc.OncRpcClient;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeNone;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcProgUnavailable;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.rpc.net.IpProtocolType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPortmapClient
implements OncPortmapClient {
    private static final Logger _log = LoggerFactory.getLogger(GenericPortmapClient.class);
    private final RpcAuth _auth = new RpcAuthTypeNone();
    private final OncPortmapClient _portmapClient;

    public GenericPortmapClient(RpcTransport transport) throws RpcProgUnavailable {
        OncPortmapClient portmapClient = new RpcbindV4Client(new RpcCall(100000, 4, this._auth, transport));
        if (!portmapClient.ping()) {
            portmapClient = new PortmapV2Client(new RpcCall(100000, 2, this._auth, transport));
            if (!portmapClient.ping()) {
                throw new RpcProgUnavailable("portmap service not available");
            }
            _log.debug("Using portmap V2");
        }
        this._portmapClient = portmapClient;
    }

    @Override
    public List<rpcb> dump() throws OncRpcException, IOException, TimeoutException {
        return this._portmapClient.dump();
    }

    @Override
    public boolean ping() {
        return this._portmapClient.ping();
    }

    @Override
    public boolean setPort(int program, int version, String netid2, String addr, String owner) throws OncRpcException, IOException, TimeoutException {
        return this._portmapClient.setPort(program, version, netid2, addr, owner);
    }

    @Override
    public boolean unsetPort(int program, int version, String owner) throws OncRpcException, IOException, TimeoutException {
        return this._portmapClient.unsetPort(program, version, owner);
    }

    @Override
    public String getPort(int program, int version, String netid2) throws OncRpcException, IOException, TimeoutException {
        return this._portmapClient.getPort(program, version, netid2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, IOException, OncRpcException, TimeoutException {
        int protocol = 6;
        OncRpcClient rpcClient = new OncRpcClient(InetAddress.getByName(null), 17, 111);
        RpcTransport transport = rpcClient.connect();
        GenericPortmapClient portmapClient = new GenericPortmapClient(transport);
        try {
            int prog = 100009;
            int vers = 4;
            String netid2 = IpProtocolType.toString(protocol);
            String user = System.getProperty("user.name");
            String addr = "127.0.0.1.8.4";
            portmapClient.ping();
            System.out.println(portmapClient.setPort(prog, vers, netid2, addr, user));
            System.out.println("getport: " + portmapClient.getPort(prog, vers, netid2));
            System.out.println("-------");
            System.out.println("getport: " + portmapClient.getPort(prog, vers, netid2));
        }
        finally {
            rpcClient.close();
        }
    }
}

