/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.portmap;

import com.sun.security.auth.UnixNumericUserPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.oncrpc4j.portmap.Port;
import org.dcache.oncrpc4j.portmap.mapping;
import org.dcache.oncrpc4j.portmap.pmaplist;
import org.dcache.oncrpc4j.portmap.rpcb;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;
import org.dcache.oncrpc4j.rpc.net.IpProtocolType;
import org.dcache.oncrpc4j.rpc.net.netid;
import org.dcache.oncrpc4j.xdr.XdrBoolean;
import org.dcache.oncrpc4j.xdr.XdrVoid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncRpcbindServer
implements RpcDispatchable {
    static final ArrayList<String> v2NetIDs = new ArrayList<String>(){
        {
            this.add("tcp");
            this.add("udp");
        }
    };
    private static final Logger _log = LoggerFactory.getLogger(OncRpcbindServer.class);
    private static final String SERVICE_OWNER_UNSPECIFIED = "unspecified";
    private static final String SERVICE_OWNER_SUPER = "superuser";
    private final Set<rpcb> _services = new HashSet<rpcb>();

    public OncRpcbindServer() {
        this._services.add(new rpcb(100000, 2, "tcp", "0.0.0.0.0.111", SERVICE_OWNER_SUPER));
        this._services.add(new rpcb(100000, 2, "udp", "0.0.0.0.0.111", SERVICE_OWNER_SUPER));
    }

    @Override
    public void dispatchOncRpcCall(RpcCall call) throws OncRpcException, IOException {
        int version = call.getProgramVersion();
        switch (version) {
            case 2: {
                this.processV2Call(call);
                break;
            }
            default: {
                call.failProgramMismatch(2, 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processV2Call(RpcCall call) throws OncRpcException, IOException {
        switch (call.getProcedure()) {
            case 0: {
                call.reply(XdrVoid.XDR_VOID);
                break;
            }
            case 1: {
                mapping newMapping = new mapping();
                call.retrieveCall(newMapping);
                rpcb rpcbMapping = new rpcb(newMapping.getProg(), newMapping.getVers(), IpProtocolType.toString(newMapping.getProt()), netid.toString(newMapping.getPort()), SERVICE_OWNER_UNSPECIFIED);
                boolean found = false;
                Set<rpcb> set = this._services;
                synchronized (set) {
                    for (rpcb c : this._services) {
                        if (c.getProg() != rpcbMapping.getProg() || c.getVers() != rpcbMapping.getVers() || !c.getNetid().equals(rpcbMapping.getNetid())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this._services.add(rpcbMapping);
                    }
                }
                call.reply(found ? XdrBoolean.False : XdrBoolean.True);
                break;
            }
            case 2: {
                mapping unsetMapping = new mapping();
                call.retrieveCall(unsetMapping);
                rpcb rpcbUnsetMapping = new rpcb(unsetMapping.getProg(), unsetMapping.getVers(), IpProtocolType.toString(unsetMapping.getProt()), netid.toString(unsetMapping.getPort()), this.getOwner(call));
                boolean removed = false;
                Set<rpcb> set = this._services;
                synchronized (set) {
                    HashSet<rpcb> target = new HashSet<rpcb>();
                    for (rpcb c : this._services) {
                        if (c.getProg() != rpcbUnsetMapping.getProg() || c.getVers() != rpcbUnsetMapping.getVers() || !c.getOwner().equals(rpcbUnsetMapping.getOwner())) continue;
                        target.add(c);
                    }
                    for (rpcb c : target) {
                        this._services.remove(c);
                        removed = true;
                    }
                }
                call.reply(removed ? XdrBoolean.True : XdrBoolean.False);
                break;
            }
            case 4: {
                pmaplist list;
                pmaplist next = list = new pmaplist();
                Set<rpcb> set = this._services;
                synchronized (set) {
                    for (rpcb m4 : this._services) {
                        if (!v2NetIDs.contains(m4.getNetid())) continue;
                        next.setEntry(new mapping(m4.getProg(), m4.getVers(), netid.idOf(m4.getNetid()), netid.getPort(m4.getAddr())));
                        pmaplist n = new pmaplist();
                        next.setNext(n);
                        next = n;
                    }
                }
                call.reply(list);
                break;
            }
            case 3: {
                mapping query = new mapping();
                call.retrieveCall(query);
                rpcb result = this.search(new rpcb(query.getProg(), query.getVers(), IpProtocolType.toString(query.getProt()), netid.toString(query.getPort()), this.getOwner(call)));
                Port port = result == null ? new Port(0) : new Port(netid.getPort(result.getAddr()));
                call.reply(port);
                break;
            }
            default: {
                call.failProcedureUnavailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private rpcb search(rpcb query) {
        Set<rpcb> set = this._services;
        synchronized (set) {
            for (rpcb e : this._services) {
                if (!e.match(query)) continue;
                return e;
            }
        }
        return null;
    }

    private String getOwner(RpcCall call) {
        Predicate<Principal> filter;
        if (call.getTransport().getRemoteSocketAddress().getPort() < 1024) {
            return SERVICE_OWNER_SUPER;
        }
        switch (call.getCredential().type()) {
            case 6: {
                filter = p -> p.getClass() == KerberosPrincipal.class;
                break;
            }
            case 1: {
                filter = p -> p.getClass() == UnixNumericUserPrincipal.class;
                break;
            }
            default: {
                filter = p -> false;
            }
        }
        return call.getCredential().getSubject().getPrincipals().stream().filter(filter).findFirst().map(Principal::getName).orElse(SERVICE_OWNER_UNSPECIFIED);
    }
}

