/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.portmap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.oncrpc4j.portmap.OncPortmapClient;
import org.dcache.oncrpc4j.portmap.mapping;
import org.dcache.oncrpc4j.portmap.pmaplist;
import org.dcache.oncrpc4j.portmap.rpcb;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.net.InetSocketAddresses;
import org.dcache.oncrpc4j.rpc.net.IpProtocolType;
import org.dcache.oncrpc4j.rpc.net.netid;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrBoolean;
import org.dcache.oncrpc4j.xdr.XdrInt;
import org.dcache.oncrpc4j.xdr.XdrVoid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortmapV2Client
implements OncPortmapClient {
    private static final String SERVICE_OWNER_UNKNOWN = "unknown";
    private static final Logger _log = LoggerFactory.getLogger(PortmapV2Client.class);
    private final RpcCall _call;

    public PortmapV2Client(RpcCall call) {
        this._call = call;
    }

    @Override
    public List<rpcb> dump() throws OncRpcException, IOException, TimeoutException {
        _log.debug("portmap dump");
        pmaplist list_reply = new pmaplist();
        this._call.call(4, (XdrAble)XdrVoid.XDR_VOID, list_reply);
        LinkedList<rpcb> out = new LinkedList<rpcb>();
        do {
            mapping c;
            if ((c = list_reply.getEntry()) == null) continue;
            out.add(new rpcb(c.getProg(), c.getVers(), IpProtocolType.toString(c.getProt()), netid.toString(c.getPort()), SERVICE_OWNER_UNKNOWN));
        } while ((list_reply = list_reply.getNext()) != null);
        return out;
    }

    @Override
    public boolean ping() {
        _log.debug("portmap ping");
        boolean pong = false;
        try {
            this._call.call(0, (XdrAble)XdrVoid.XDR_VOID, XdrVoid.XDR_VOID, 2L, TimeUnit.SECONDS);
            pong = true;
        }
        catch (IOException | TimeoutException exception) {
            // empty catch block
        }
        return pong;
    }

    @Override
    public boolean setPort(int program, int version, String netids, String addr, String ignored) throws OncRpcException, IOException, TimeoutException {
        _log.debug("portmap set port: prog: {} vers: {}, netid: {} addr: {}", program, version, netids, addr);
        int protocol = netid.idOf(netids);
        if (protocol == -1) {
            return false;
        }
        InetSocketAddress address = netid.toInetSocketAddress(addr);
        mapping m1 = new mapping(program, version, protocol, address.getPort());
        XdrBoolean isSet = new XdrBoolean();
        this._call.call(1, (XdrAble)m1, isSet);
        return isSet.booleanValue();
    }

    @Override
    public boolean unsetPort(int program, int version, String ignored) throws OncRpcException, IOException, TimeoutException {
        _log.debug("portmap unset port: prog: {} vers: {}", (Object)program, (Object)version);
        mapping m4 = new mapping(program, version, 0, -1);
        XdrBoolean isSet = new XdrBoolean();
        this._call.call(2, (XdrAble)m4, isSet);
        return isSet.booleanValue();
    }

    @Override
    public String getPort(int program, int version, String nid) throws OncRpcException, IOException, TimeoutException {
        mapping m4 = new mapping(program, version, netid.idOf(nid), 0);
        XdrInt port = new XdrInt();
        this._call.call(3, (XdrAble)m4, port);
        return InetSocketAddresses.uaddrOf(this._call.getTransport().getRemoteSocketAddress().getAddress().getHostAddress(), port.intValue());
    }
}

