/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.oncrpc4j.rpc.MismatchInfo;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.ReplyQueue;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeTls;
import org.dcache.oncrpc4j.rpc.RpcCredential;
import org.dcache.oncrpc4j.rpc.RpcMismatchReply;
import org.dcache.oncrpc4j.rpc.RpcReply;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrVoid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCall {
    private static final Logger _log = LoggerFactory.getLogger(RpcCall.class);
    private static final Random RND = new Random();
    private final AtomicInteger xidGenerator = new AtomicInteger(RND.nextInt());
    private int _xid;
    private static final int RPCVERS = 2;
    private int _prog;
    private int _version;
    private int _proc;
    private int _rpcvers;
    private RpcAuth _cred;
    private final RpcTransport _transport;
    private final Xdr _xdr;
    private final Object _listenerLock = new Object();
    private static final CompletionHandler<RpcReply, RpcTransport> NOOP = new CompletionHandler<RpcReply, RpcTransport>(){

        @Override
        public void completed(RpcReply result, RpcTransport transport) {
        }

        @Override
        public void failed(Throwable exc, RpcTransport attachment) {
        }
    };
    private List<CompletionHandler<Integer, InetSocketAddress>> _sendListeners;
    private List<CompletionHandler<Integer, InetSocketAddress>> _sendOnceListeners;
    private final CompletionHandler<Integer, InetSocketAddress> _sendNotificationHandler = new NotifyListenersCompletionHandler();

    public RpcCall(int prog, int ver, RpcAuth cred, RpcTransport transport) {
        this(prog, ver, cred, new Xdr(1024), transport);
    }

    public RpcCall(int prog, int ver, RpcAuth cred, Xdr xdr, RpcTransport transport) {
        this._prog = prog;
        this._version = ver;
        this._cred = cred;
        this._transport = transport;
        this._xdr = xdr;
        this._proc = 0;
    }

    public RpcCall(int xid, Xdr xdr, RpcTransport transport) {
        this._xid = xid;
        this._xdr = xdr;
        this._transport = transport;
    }

    public RpcCall(int xid, int prog, int ver, int proc, RpcAuth cred, Xdr xdr, RpcTransport transport) {
        this._xid = xid;
        this._prog = prog;
        this._version = ver;
        this._proc = proc;
        this._cred = cred;
        this._xdr = xdr;
        this._transport = transport;
        this._rpcvers = 2;
    }

    public void accept() throws IOException {
        this._rpcvers = this._xdr.xdrDecodeInt();
        if (this._rpcvers != 2) {
            throw new RpcMismatchReply(this._rpcvers, 2);
        }
        this._prog = this._xdr.xdrDecodeInt();
        this._version = this._xdr.xdrDecodeInt();
        this._proc = this._xdr.xdrDecodeInt();
        this._cred = RpcCredential.decode(this._xdr, this._transport);
    }

    public int getProgram() {
        return this._prog;
    }

    public int getProgramVersion() {
        return this._version;
    }

    public int getProcedure() {
        return this._proc;
    }

    public RpcAuth getCredential() {
        return this._cred;
    }

    public RpcTransport getTransport() {
        return this._transport;
    }

    public int getXid() {
        return this._xid;
    }

    public Xdr getXdr() {
        return this._xdr;
    }

    public String toString() {
        return String.format("RPCv%d call: program=%d, version=%d, procedure=%d", this._rpcvers, this._prog, this._version, this._proc);
    }

    @Beta
    public void startTLS() throws IOException {
        this.call(0, (XdrAble)XdrVoid.XDR_VOID, XdrVoid.XDR_VOID, (RpcAuth)new RpcAuthTypeTls());
        this.getTransport().startTLS();
    }

    public void reject(int status, XdrAble reason) {
        Xdr xdr = this._xdr;
        try {
            xdr.beginEncoding();
            xdr.xdrEncodeInt(this._xid);
            xdr.xdrEncodeInt(1);
            xdr.xdrEncodeInt(1);
            xdr.xdrEncodeInt(status);
            reason.xdrEncode(this._xdr);
            xdr.endEncoding();
            this._transport.send(xdr, this._transport.getRemoteSocketAddress(), this._sendNotificationHandler);
        }
        catch (OncRpcException e) {
            _log.warn("Xdr exception: ", e);
        }
        catch (IOException e) {
            _log.error("Failed send reply: ", e);
        }
    }

    public void reply(XdrAble reply) {
        this.acceptedReply(0, reply);
    }

    public void acceptedReply(int state, XdrAble reply) {
        Xdr xdr = this._xdr;
        try {
            xdr.beginEncoding();
            xdr.xdrEncodeInt(this._xid);
            xdr.xdrEncodeInt(1);
            xdr.xdrEncodeInt(0);
            this._cred.getVerifier().xdrEncode(xdr);
            xdr.xdrEncodeInt(state);
            reply.xdrEncode(xdr);
            xdr.endEncoding();
            this._transport.send(xdr, this._transport.getRemoteSocketAddress(), this._sendNotificationHandler);
        }
        catch (OncRpcException e) {
            _log.warn("Xdr exception: ", e);
        }
        catch (IOException e) {
            _log.error("Failed send reply: ", e);
        }
    }

    public void retrieveCall(XdrAble args) throws OncRpcException, IOException {
        args.xdrDecode(this._xdr);
        this._xdr.endDecoding();
    }

    public void failProgramMismatch(int min2, int max) {
        this.acceptedReply(2, new MismatchInfo(min2, max));
    }

    public void failProgramUnavailable() {
        this.acceptedReply(1, XdrVoid.XDR_VOID);
    }

    public void failProcedureUnavailable() {
        this.acceptedReply(3, XdrVoid.XDR_VOID);
    }

    public void failRpcGarbage() {
        this.acceptedReply(4, XdrVoid.XDR_VOID);
    }

    public void failRpcSystem() {
        this.acceptedReply(5, XdrVoid.XDR_VOID);
    }

    public void call(int procedure, XdrAble args, CompletionHandler<RpcReply, RpcTransport> callback, long timeoutValue, TimeUnit timeoutUnits, RpcAuth auth) throws IOException {
        this.callInternal(procedure, args, callback, timeoutValue, timeoutUnits, auth);
    }

    public void call(int procedure, XdrAble args, CompletionHandler<RpcReply, RpcTransport> callback, long timeoutValue, TimeUnit timeoutUnits) throws IOException {
        this.call(procedure, args, callback, timeoutValue, timeoutUnits, null);
    }

    public void call(int procedure, XdrAble args, CompletionHandler<RpcReply, RpcTransport> callback, RpcAuth auth) throws IOException {
        this.call(procedure, args, callback, 0L, null, auth);
    }

    public void call(int procedure, XdrAble args, CompletionHandler<RpcReply, RpcTransport> callback) throws IOException {
        this.call(procedure, args, callback, 0L, null, null);
    }

    private int callInternal(int procedure, XdrAble args, CompletionHandler<RpcReply, RpcTransport> callback, long timeoutValue, TimeUnit timeoutUnits, RpcAuth auth) throws IOException {
        final int xid = this.nextXid();
        Xdr xdr = new Xdr(1024);
        xdr.beginEncoding();
        xdr.xdrEncodeInt(xid);
        xdr.xdrEncodeInt(0);
        xdr.xdrEncodeInt(2);
        xdr.xdrEncodeInt(this._prog);
        xdr.xdrEncodeInt(this._version);
        xdr.xdrEncodeInt(procedure);
        if (auth != null) {
            auth.xdrEncode(xdr);
        } else {
            this._cred.xdrEncode(xdr);
        }
        args.xdrEncode(xdr);
        xdr.endEncoding();
        final ReplyQueue replyQueue = this._transport.getReplyQueue();
        final CompletionHandler<RpcReply, RpcTransport> handler = callback == null ? NOOP : callback;
        replyQueue.registerKey(xid, this._transport.getLocalSocketAddress(), callback, timeoutValue, timeoutUnits);
        this._transport.send(xdr, this._transport.getRemoteSocketAddress(), new NotifyListenersCompletionHandler(){

            @Override
            public void failed(Throwable t2, InetSocketAddress attachment) {
                super.failed(t2, attachment);
                replyQueue.get(xid);
                handler.failed(t2, RpcCall.this._transport);
            }
        });
        return xid;
    }

    public <T extends XdrAble> CompletableFuture<T> call(int procedure, XdrAble args, Class<T> type, RpcAuth auth) throws IOException {
        try {
            XdrAble result = (XdrAble)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.getCallFuture(procedure, args, result, 0L, null, auth);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create in instance of " + type, e);
        }
    }

    public <T extends XdrAble> CompletableFuture<T> call(int procedure, XdrAble args, Class<T> type) throws IOException {
        return this.call(procedure, args, type, null);
    }

    public void call(int procedure, XdrAble args, XdrAble result, long timeoutValue, TimeUnit timeoutUnits, RpcAuth auth) throws IOException, TimeoutException {
        try {
            CompletableFuture<XdrAble> future = this.getCallFuture(procedure, args, result, timeoutValue, timeoutUnits, auth);
            future.get();
        }
        catch (InterruptedException e) {
            InterruptedIOException ioe = new InterruptedIOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (ExecutionException e) {
            Throwable t2 = Throwables.getRootCause(e);
            Throwables.throwIfInstanceOf(t2, OncRpcException.class);
            Throwables.throwIfInstanceOf(t2, IOException.class);
            Throwables.throwIfInstanceOf(t2, TimeoutException.class);
            throw new IOException(t2);
        }
    }

    public void call(int procedure, XdrAble args, XdrAble result, long timeoutValue, TimeUnit timeoutUnits) throws IOException, TimeoutException {
        this.call(procedure, args, result, timeoutValue, timeoutUnits, null);
    }

    public void call(int procedure, XdrAble args, XdrAble result, RpcAuth auth) throws IOException {
        try {
            this.call(procedure, args, result, 0L, null, auth);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    public void call(int procedure, XdrAble args, XdrAble result) throws IOException {
        try {
            this.call(procedure, args, result, 0L, null, null);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    private <T extends XdrAble> CompletableFuture<T> getCallFuture(int procedure, XdrAble args, final T result, long timeoutValue, TimeUnit timeoutUnits, RpcAuth auth) throws IOException {
        final TimeoutAwareFuture future = new TimeoutAwareFuture();
        CompletionHandler<RpcReply, RpcTransport> callback = new CompletionHandler<RpcReply, RpcTransport>(){

            @Override
            public void completed(RpcReply reply, RpcTransport attachment) {
                try {
                    reply.getReplyResult(result);
                    future.complete(result);
                }
                catch (IOException e) {
                    this.failed((Throwable)e, attachment);
                }
            }

            @Override
            public void failed(Throwable exc, RpcTransport attachment) {
                future.completeExceptionally(exc);
            }
        };
        int xid = this.callInternal(procedure, args, callback, timeoutValue, timeoutUnits, auth);
        return timeoutValue > 0L ? future : new TimeoutAwareFuture(future, xid);
    }

    private int nextXid() {
        return this.xidGenerator.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSendListener(CompletionHandler<Integer, InetSocketAddress> listener) {
        Object object = this._listenerLock;
        synchronized (object) {
            if (this._sendListeners == null) {
                this._sendListeners = new ArrayList<CompletionHandler<Integer, InetSocketAddress>>();
            }
            this._sendListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSendOnceListener(CompletionHandler<Integer, InetSocketAddress> listener) {
        Object object = this._listenerLock;
        synchronized (object) {
            if (this._sendOnceListeners == null) {
                this._sendOnceListeners = new ArrayList<CompletionHandler<Integer, InetSocketAddress>>();
            }
            this._sendOnceListeners.add(listener);
        }
    }

    private class TimeoutAwareFuture<T>
    extends CompletableFuture<T> {
        private final Future<T> delegate;
        private final int xid;

        public TimeoutAwareFuture(Future<T> delegate, int xid) {
            this.delegate = delegate;
            this.xid = xid;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                boolean bl = this.delegate.cancel(mayInterruptIfRunning);
                return bl;
            }
            finally {
                if (mayInterruptIfRunning) {
                    this.unregisterXid();
                }
            }
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                T t2 = this.delegate.get();
                return t2;
            }
            finally {
                this.unregisterXid();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                T t2 = this.delegate.get(timeout, unit);
                return t2;
            }
            finally {
                this.unregisterXid();
            }
        }

        private void unregisterXid() {
            RpcCall.this._transport.getReplyQueue().get(this.xid);
        }
    }

    private class NotifyListenersCompletionHandler
    implements CompletionHandler<Integer, InetSocketAddress> {
        private NotifyListenersCompletionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, InetSocketAddress attachment) {
            Object object = RpcCall.this._listenerLock;
            synchronized (object) {
                if (RpcCall.this._sendListeners != null) {
                    RpcCall.this._sendListeners.parallelStream().forEach(l -> l.completed(result, attachment));
                }
                if (RpcCall.this._sendOnceListeners != null) {
                    RpcCall.this._sendOnceListeners.parallelStream().forEach(l -> l.completed(result, attachment));
                    RpcCall.this._sendOnceListeners = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable t2, InetSocketAddress attachment) {
            _log.error("Failed to send RPC to {} : {}", (Object)attachment, (Object)t2.getMessage());
            Object object = RpcCall.this._listenerLock;
            synchronized (object) {
                if (RpcCall.this._sendListeners != null) {
                    RpcCall.this._sendListeners.parallelStream().forEach(l -> l.failed(t2, attachment));
                }
                if (RpcCall.this._sendOnceListeners != null) {
                    RpcCall.this._sendOnceListeners.parallelStream().forEach(l -> l.failed(t2, attachment));
                    RpcCall.this._sendOnceListeners = null;
                }
            }
        }
    }
}

