/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CompletionHandler;
import org.dcache.oncrpc4j.grizzly.GrizzlyRpcTransport;
import org.dcache.oncrpc4j.rpc.OncRpcAcceptedException;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.OncRpcRejectedException;
import org.dcache.oncrpc4j.rpc.ReplyQueue;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcException;
import org.dcache.oncrpc4j.rpc.RpcReply;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcProtocolFilter
extends BaseFilter {
    private static final Logger _log = LoggerFactory.getLogger(RpcProtocolFilter.class);
    private final ReplyQueue _replyQueue;

    public RpcProtocolFilter(ReplyQueue replyQueue) {
        this._replyQueue = replyQueue;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Xdr xdr = (Xdr)ctx.getMessage();
        if (xdr == null) {
            _log.error("Parser returns bad XDR");
            return ctx.getStopAction();
        }
        xdr.beginDecoding();
        int xid = xdr.xdrDecodeInt();
        int type = xdr.xdrDecodeInt();
        GrizzlyRpcTransport transport = new GrizzlyRpcTransport(ctx.getConnection(), (InetSocketAddress)ctx.getAddress(), this._replyQueue);
        switch (type) {
            case 0: {
                RpcCall call = new RpcCall(xid, xdr, transport);
                try {
                    call.accept();
                    ctx.setMessage(call);
                }
                catch (RpcException e) {
                    call.reject(e.getStatus(), e.getRpcReply());
                    _log.info("RPC request rejected: {}", (Object)e.getMessage());
                    return ctx.getStopAction();
                }
                catch (OncRpcException e) {
                    _log.info("failed to process RPC request: {}", (Object)e.getMessage());
                    return ctx.getStopAction();
                }
                return ctx.getInvokeAction();
            }
            case 1: {
                try {
                    RpcReply reply = new RpcReply(xid, xdr, transport);
                    CompletionHandler<RpcReply, RpcTransport> callback = this._replyQueue.get(xid);
                    if (callback != null) {
                        if (!reply.isAccepted()) {
                            callback.failed(new OncRpcRejectedException(reply.getRejectStatus()), transport);
                        } else if (reply.getAcceptStatus() != 0) {
                            callback.failed(new OncRpcAcceptedException(reply.getAcceptStatus()), transport);
                        } else {
                            callback.completed(reply, transport);
                        }
                    }
                }
                catch (OncRpcException e) {
                    _log.warn("failed to decode reply:", e);
                }
                return ctx.getStopAction();
            }
        }
        return ctx.getStopAction();
    }
}

