/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import java.io.IOException;
import org.dcache.oncrpc4j.rpc.MismatchInfo;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.RpcAccepsStatus;
import org.dcache.oncrpc4j.rpc.RpcAuthStat;
import org.dcache.oncrpc4j.rpc.RpcAuthVerifier;
import org.dcache.oncrpc4j.rpc.RpcRejectStatus;
import org.dcache.oncrpc4j.rpc.RpcReplyStatus;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcReply {
    private static final Logger _log = LoggerFactory.getLogger(RpcReply.class);
    private final int _xid;
    private final Xdr _xdr;
    private int _replyStatus;
    private int _acceptedStatus;
    private int _rejectStatus;
    private MismatchInfo _mismatchInfo;
    private int _authStatus;
    private RpcAuthVerifier _verf;
    private final RpcTransport _transport;

    public RpcReply(int xid, Xdr xdr, RpcTransport transport) throws OncRpcException, IOException {
        this._xid = xid;
        this._xdr = xdr;
        this._transport = transport;
        this._replyStatus = xdr.xdrDecodeInt();
        switch (this._replyStatus) {
            case 0: {
                this._verf = new RpcAuthVerifier(xdr);
                this._acceptedStatus = xdr.xdrDecodeInt();
                switch (this._acceptedStatus) {
                    case 2: {
                        this._mismatchInfo = new MismatchInfo();
                        this._mismatchInfo.xdrDecode(xdr);
                    }
                }
                break;
            }
            case 1: {
                this._rejectStatus = xdr.xdrDecodeInt();
                switch (this._rejectStatus) {
                    case 0: {
                        this._mismatchInfo = new MismatchInfo();
                        this._mismatchInfo.xdrDecode(xdr);
                        break;
                    }
                    case 1: {
                        this._authStatus = xdr.xdrDecodeInt();
                    }
                }
                break;
            }
        }
    }

    public boolean isAccepted() {
        return this._replyStatus == 0;
    }

    public int getAcceptStatus() {
        if (!this.isAccepted()) {
            throw new IllegalStateException("Message in not accepted");
        }
        return this._acceptedStatus;
    }

    public MismatchInfo getMismatchInfo() {
        return this._mismatchInfo;
    }

    public int getAuthStatus() {
        return this._authStatus;
    }

    public int getRejectStatus() {
        if (this.isAccepted()) {
            throw new IllegalStateException("Message is accepted");
        }
        return this._rejectStatus;
    }

    public void getReplyResult(XdrAble result) throws OncRpcException, IOException {
        result.xdrDecode(this._xdr);
        this._xdr.endDecoding();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("xid: ").append(this._xid);
        sb.append(" Status: ").append(RpcReplyStatus.toString(this._replyStatus));
        if (this._replyStatus == 0) {
            sb.append(" AccespStatus: ").append(RpcAccepsStatus.toString(this._acceptedStatus));
            if (this._acceptedStatus == 2) {
                sb.append(" :").append(this._mismatchInfo);
            }
        } else {
            sb.append(" RejectStatus: ").append(RpcRejectStatus.toString(this._rejectStatus));
            if (this._rejectStatus == 1) {
                sb.append(" AuthError: ").append(RpcAuthStat.toString(this._authStatus));
            }
        }
        return sb.toString();
    }
}

