/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc.gss;

import java.io.IOException;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.RpcAuthError;
import org.dcache.oncrpc4j.rpc.RpcAuthException;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.gss.DataBodyIntegrity;
import org.dcache.oncrpc4j.rpc.gss.DataBodyPrivacy;
import org.dcache.oncrpc4j.rpc.gss.RpcAuthGss;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcGssCall
extends RpcCall {
    private static final Logger _log = LoggerFactory.getLogger(RpcGssCall.class);
    private final GSSContext _gssContext;
    private final MessageProp _mop;

    public RpcGssCall(RpcCall call, GSSContext gssContext, MessageProp mop) {
        super(call.getXid(), call.getProgram(), call.getProgramVersion(), call.getProcedure(), call.getCredential(), call.getXdr(), call.getTransport());
        this._gssContext = gssContext;
        this._mop = mop;
    }

    @Override
    public void retrieveCall(XdrAble args) throws OncRpcException, IOException {
        try {
            RpcAuthGss authGss = (RpcAuthGss)this.getCredential();
            _log.debug("Call with GSS service: {}", (Object)authGss.getService());
            switch (authGss.getService()) {
                case 1: {
                    super.retrieveCall(args);
                    break;
                }
                case 2: {
                    DataBodyIntegrity integData = new DataBodyIntegrity();
                    super.retrieveCall(integData);
                    byte[] integBytes = integData.getData();
                    byte[] checksum = integData.getChecksum();
                    this._gssContext.verifyMIC(checksum, 0, checksum.length, integBytes, 0, integBytes.length, this._mop);
                    Xdr xdr = new Xdr(integBytes);
                    xdr.beginDecoding();
                    xdr.xdrDecodeInt();
                    args.xdrDecode(xdr);
                    xdr.endDecoding();
                    break;
                }
                case 3: {
                    DataBodyPrivacy privacyData = new DataBodyPrivacy();
                    super.retrieveCall(privacyData);
                    byte[] privacyBytes = privacyData.getData();
                    byte[] rawData = this._gssContext.unwrap(privacyBytes, 0, privacyBytes.length, this._mop);
                    Xdr xdr = new Xdr(rawData);
                    xdr.beginDecoding();
                    xdr.xdrDecodeInt();
                    args.xdrDecode(xdr);
                    xdr.endDecoding();
                }
            }
        }
        catch (GSSException e) {
            _log.error("GSS error: {}", (Object)e.getMessage());
            throw new RpcAuthException("GSS error: " + e.getMessage(), new RpcAuthError(14));
        }
    }

    @Override
    public void acceptedReply(int state, XdrAble reply) {
        try {
            RpcAuthGss authGss = (RpcAuthGss)this.getCredential();
            _log.debug("Reply with GSS service: {}", (Object)authGss.getService());
            switch (authGss.getService()) {
                case 1: {
                    super.acceptedReply(state, reply);
                    break;
                }
                case 2: {
                    byte[] integBytes;
                    try (Xdr xdr = new Xdr(262144);){
                        xdr.beginEncoding();
                        xdr.xdrEncodeInt(authGss.getSequence());
                        reply.xdrEncode(xdr);
                        xdr.endEncoding();
                        integBytes = xdr.getBytes();
                    }
                    byte[] checksum = this._gssContext.getMIC(integBytes, 0, integBytes.length, this._mop);
                    DataBodyIntegrity integData = new DataBodyIntegrity(integBytes, checksum);
                    super.acceptedReply(state, integData);
                    break;
                }
                case 3: {
                    byte[] rawData;
                    try (Xdr xdr = new Xdr(262144);){
                        xdr.beginEncoding();
                        xdr.xdrEncodeInt(authGss.getSequence());
                        reply.xdrEncode(xdr);
                        xdr.endEncoding();
                        rawData = xdr.getBytes();
                    }
                    byte[] privacyBytes = this._gssContext.wrap(rawData, 0, rawData.length, this._mop);
                    DataBodyPrivacy privacyData = new DataBodyPrivacy(privacyBytes);
                    super.acceptedReply(state, privacyData);
                }
            }
        }
        catch (IOException e) {
            _log.error("IO error: {}", (Object)e.getMessage());
            super.reject(1, new RpcAuthError(14));
        }
        catch (GSSException e) {
            _log.error("GSS error: {}", (Object)e.getMessage());
            super.reject(1, new RpcAuthError(14));
        }
    }
}

