/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs4j.server;

import com.google.common.primitives.Longs;
import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.status.ExistException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.NotEmptyException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.status.PermException;
import org.dcache.nfs.status.ServerFaultException;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.SimpleIdMap;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSystem
implements VirtualFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileSystem.class);
    private final Path _root;
    private final NonBlockingHashMapLong<Path> inodeToPath = new NonBlockingHashMapLong();
    private final NonBlockingHashMap<Path, Long> pathToInode = new NonBlockingHashMap();
    private final AtomicLong fileId = new AtomicLong(1L);
    private final NfsIdMapping _idMapper = new SimpleIdMap();
    private final UserPrincipalLookupService _lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
    private static final boolean IS_UNIX = !System.getProperty("os.name").startsWith("Win");

    private Inode toFh(long inodeNumber) {
        return Inode.forFile((byte[])Longs.toByteArray((long)inodeNumber));
    }

    private long getInodeNumber(Inode inode) {
        return Longs.fromByteArray((byte[])inode.getFileId());
    }

    private Path resolveInode(long inodeNumber) throws NoEntException {
        Path path = (Path)this.inodeToPath.get(inodeNumber);
        if (path == null) {
            throw new NoEntException("inode #" + inodeNumber);
        }
        return path;
    }

    private long resolvePath(Path path) throws NoEntException {
        Long inodeNumber = (Long)this.pathToInode.get((Object)path);
        if (inodeNumber == null) {
            throw new NoEntException("path " + path);
        }
        return inodeNumber;
    }

    private void map(long inodeNumber, Path path, boolean force) {
        if (this.inodeToPath.putIfAbsent(inodeNumber, (Object)path) != null) {
            throw new IllegalStateException();
        }
        if (force) {
            this.pathToInode.put((Object)path, (Object)inodeNumber);
        } else {
            Long otherInodeNumber = (Long)this.pathToInode.putIfAbsent((Object)path, (Object)inodeNumber);
            if (otherInodeNumber != null) {
                if (this.inodeToPath.remove(inodeNumber) != path) {
                    throw new IllegalStateException("cant map, rollback failed");
                }
                throw new IllegalStateException("path " + path + " already mapped to " + otherInodeNumber);
            }
        }
    }

    private void map(long inodeNumber, Path path) {
        this.map(inodeNumber, path, false);
    }

    private void unmap(long inodeNumber, Path path) {
        Path removedPath = (Path)this.inodeToPath.remove(inodeNumber);
        if (!path.equals(removedPath)) {
            throw new IllegalStateException();
        }
        if ((Long)this.pathToInode.remove((Object)path) != inodeNumber) {
            throw new IllegalStateException();
        }
    }

    private void remap(long inodeNumber, Path oldPath, Path newPath) {
        this.unmap(inodeNumber, oldPath);
        this.map(inodeNumber, newPath, true);
    }

    public LocalFileSystem(Path root, Iterable<FsExport> exportIterable) throws IOException {
        this._root = root;
        assert (Files.exists(this._root, new LinkOption[0]));
        for (FsExport export : exportIterable) {
            String relativeExportPath = export.getPath().substring(1);
            Path exportRootPath = root.resolve(relativeExportPath);
            if (Files.exists(exportRootPath, new LinkOption[0])) continue;
            Files.createDirectories(exportRootPath, new FileAttribute[0]);
        }
        this.map(this.fileId.getAndIncrement(), this._root);
        Files.walkFileTree(this._root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileVisitResult superRes = super.preVisitDirectory(dir, attrs);
                if (superRes != FileVisitResult.CONTINUE) {
                    return superRes;
                }
                if (dir.equals(LocalFileSystem.this._root)) {
                    return FileVisitResult.CONTINUE;
                }
                LocalFileSystem.this.map(LocalFileSystem.this.fileId.getAndIncrement(), dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileVisitResult superRes = super.visitFile(file, attrs);
                if (superRes != FileVisitResult.CONTINUE) {
                    return superRes;
                }
                LocalFileSystem.this.map(LocalFileSystem.this.fileId.getAndIncrement(), file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        long parentInodeNumber = this.getInodeNumber(parent);
        Path parentPath = this.resolveInode(parentInodeNumber);
        Path newPath = parentPath.resolve(path);
        try {
            Files.createFile(newPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw new ExistException("path " + newPath);
        }
        long newInodeNumber = this.fileId.getAndIncrement();
        this.map(newInodeNumber, newPath);
        this.setOwnershipAndMode(newPath, subject, mode);
        return this.toFh(newInodeNumber);
    }

    public FsStat getFsStat() throws IOException {
        FileStore store = Files.getFileStore(this._root);
        long total = store.getTotalSpace();
        long free = store.getUsableSpace();
        return new FsStat(total, Long.MAX_VALUE, total - free, (long)this.pathToInode.size());
    }

    public Inode getRootInode() throws IOException {
        return this.toFh(1L);
    }

    public Inode lookup(Inode parent, String path) throws IOException {
        long parentInodeNumber = this.getInodeNumber(parent);
        Path parentPath = this.resolveInode(parentInodeNumber);
        Path child = path.equals(".") ? parentPath : (path.equals("..") ? parentPath.getParent() : parentPath.resolve(path));
        long childInodeNumber = this.resolvePath(child);
        return this.toFh(childInodeNumber);
    }

    public Inode link(Inode parent, Inode existing, String target, Subject subject) throws IOException {
        long parentInodeNumber = this.getInodeNumber(parent);
        Path parentPath = this.resolveInode(parentInodeNumber);
        long existingInodeNumber = this.getInodeNumber(existing);
        Path existingPath = this.resolveInode(existingInodeNumber);
        Path targetPath = parentPath.resolve(target);
        try {
            Files.createLink(targetPath, existingPath);
        }
        catch (UnsupportedOperationException e) {
            throw new NotSuppException("Not supported", (Throwable)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new ExistException("Path exists " + target, (Throwable)e);
        }
        catch (SecurityException e) {
            throw new PermException("Permission denied: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ServerFaultException("Failed to create: " + e.getMessage(), (Throwable)e);
        }
        long newInodeNumber = this.fileId.getAndIncrement();
        this.map(newInodeNumber, targetPath);
        return this.toFh(newInodeNumber);
    }

    public org.dcache.nfs.vfs.DirectoryStream list(Inode inode, byte[] bytes, long l) throws IOException {
        long inodeNumber = this.getInodeNumber(inode);
        Path path = this.resolveInode(inodeNumber);
        ArrayList<DirectoryEntry> list = new ArrayList<DirectoryEntry>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
            int cookie = 2;
            for (Path p : ds) {
                if ((long)(++cookie) <= l) continue;
                long ino = this.resolvePath(p);
                list.add(new DirectoryEntry(p.getFileName().toString(), this.toFh(ino), this.statPath(p, ino), (long)cookie));
            }
        }
        return new org.dcache.nfs.vfs.DirectoryStream(list);
    }

    public byte[] directoryVerifier(Inode inode) throws IOException {
        return org.dcache.nfs.vfs.DirectoryStream.ZERO_VERIFIER;
    }

    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        long parentInodeNumber = this.getInodeNumber(parent);
        Path parentPath = this.resolveInode(parentInodeNumber);
        Path newPath = parentPath.resolve(path);
        try {
            Files.createDirectory(newPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw new ExistException("path " + newPath);
        }
        long newInodeNumber = this.fileId.getAndIncrement();
        this.map(newInodeNumber, newPath);
        this.setOwnershipAndMode(newPath, subject, mode);
        return this.toFh(newInodeNumber);
    }

    private void setOwnershipAndMode(Path target, Subject subject, int mode) {
        if (!IS_UNIX) {
            return;
        }
        int uid = -1;
        int gid = -1;
        for (Principal principal : subject.getPrincipals()) {
            if (principal instanceof UnixNumericUserPrincipal) {
                uid = (int)((UnixNumericUserPrincipal)principal).longValue();
            }
            if (!(principal instanceof UnixNumericGroupPrincipal)) continue;
            gid = (int)((UnixNumericGroupPrincipal)principal).longValue();
        }
        if (uid != -1) {
            try {
                Files.setAttribute(target, "unix:uid", uid, LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                LOG.warn("Unable to chown file {}: {}", (Object)target, (Object)e.getMessage());
            }
        } else {
            LOG.warn("File created without uid: {}", (Object)target);
        }
        if (gid != -1) {
            try {
                Files.setAttribute(target, "unix:gid", gid, LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                LOG.warn("Unable to chown file {}: {}", (Object)target, (Object)e.getMessage());
            }
        } else {
            LOG.warn("File created without gid: {}", (Object)target);
        }
        try {
            Files.setAttribute(target, "unix:mode", mode, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            LOG.warn("Unable to set mode of file {}: {}", (Object)target, (Object)e.getMessage());
        }
    }

    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        long currentParentInodeNumber = this.getInodeNumber(src);
        Path currentParentPath = this.resolveInode(currentParentInodeNumber);
        long destParentInodeNumber = this.getInodeNumber(dest);
        Path destPath = this.resolveInode(destParentInodeNumber);
        Path currentPath = currentParentPath.resolve(oldName);
        long targetInodeNumber = this.resolvePath(currentPath);
        Path newPath = destPath.resolve(newName);
        try {
            Files.move(currentPath, newPath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (FileAlreadyExistsException e) {
            throw new ExistException("path " + newPath);
        }
        this.remap(targetInodeNumber, currentPath, newPath);
        return true;
    }

    public Inode parentOf(Inode inode) throws IOException {
        long inodeNumber = this.getInodeNumber(inode);
        if (inodeNumber == 1L) {
            throw new NoEntException("no parent");
        }
        Path path = this.resolveInode(inodeNumber);
        Path parentPath = path.getParent();
        long parentInodeNumber = this.resolvePath(parentPath);
        return this.toFh(parentInodeNumber);
    }

    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        long inodeNumber = this.getInodeNumber(inode);
        Path path = this.resolveInode(inodeNumber);
        ByteBuffer destBuffer = ByteBuffer.wrap(data, 0, count);
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            int n = channel.read(destBuffer, offset);
            return n;
        }
    }

    public String readlink(Inode inode) throws IOException {
        long inodeNumber = this.getInodeNumber(inode);
        Path path = this.resolveInode(inodeNumber);
        return Files.readSymbolicLink(path).toString();
    }

    public void remove(Inode parent, String path) throws IOException {
        long parentInodeNumber = this.getInodeNumber(parent);
        Path parentPath = this.resolveInode(parentInodeNumber);
        Path targetPath = parentPath.resolve(path);
        long targetInodeNumber = this.resolvePath(targetPath);
        try {
            Files.delete(targetPath);
        }
        catch (DirectoryNotEmptyException e) {
            throw new NotEmptyException("dir " + targetPath + " is note empty", (Throwable)e);
        }
        this.unmap(targetInodeNumber, targetPath);
    }

    public Inode symlink(Inode parent, String linkName, String targetName, Subject subject, int mode) throws IOException {
        long parentInodeNumber = this.getInodeNumber(parent);
        Path parentPath = this.resolveInode(parentInodeNumber);
        Path link = parentPath.resolve(linkName);
        Path target = parentPath.resolve(targetName);
        if (!targetName.startsWith("/")) {
            target = parentPath.relativize(target);
        }
        try {
            Files.createSymbolicLink(link, target, new FileAttribute[0]);
        }
        catch (UnsupportedOperationException e) {
            throw new NotSuppException("Not supported", (Throwable)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new ExistException("Path exists " + linkName, (Throwable)e);
        }
        catch (SecurityException e) {
            throw new PermException("Permission denied: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ServerFaultException("Failed to create: " + e.getMessage(), (Throwable)e);
        }
        this.setOwnershipAndMode(link, subject, mode);
        long newInodeNumber = this.fileId.getAndIncrement();
        this.map(newInodeNumber, link);
        return this.toFh(newInodeNumber);
    }

    public VirtualFileSystem.WriteResult write(Inode inode, byte[] data, long offset, int count, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        long inodeNumber = this.getInodeNumber(inode);
        Path path = this.resolveInode(inodeNumber);
        ByteBuffer srcBuffer = ByteBuffer.wrap(data, 0, count);
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.WRITE);){
            int bytesWritten = channel.write(srcBuffer, offset);
            VirtualFileSystem.WriteResult writeResult = new VirtualFileSystem.WriteResult(VirtualFileSystem.StabilityLevel.FILE_SYNC, bytesWritten);
            return writeResult;
        }
    }

    public void commit(Inode inode, long l, int i) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Stat statPath(Path p, long inodeNumber) throws IOException {
        Class attributeClass = IS_UNIX ? PosixFileAttributeView.class : DosFileAttributeView.class;
        BasicFileAttributes attrs = ((BasicFileAttributeView)Files.getFileAttributeView(p, attributeClass, LinkOption.NOFOLLOW_LINKS)).readAttributes();
        Stat stat = new Stat();
        stat.setATime(attrs.lastAccessTime().toMillis());
        stat.setCTime(attrs.creationTime().toMillis());
        stat.setMTime(attrs.lastModifiedTime().toMillis());
        if (IS_UNIX) {
            stat.setGid(((Integer)Files.getAttribute(p, "unix:gid", LinkOption.NOFOLLOW_LINKS)).intValue());
            stat.setUid(((Integer)Files.getAttribute(p, "unix:uid", LinkOption.NOFOLLOW_LINKS)).intValue());
            stat.setMode(((Integer)Files.getAttribute(p, "unix:mode", LinkOption.NOFOLLOW_LINKS)).intValue());
            stat.setNlink(((Integer)Files.getAttribute(p, "unix:nlink", LinkOption.NOFOLLOW_LINKS)).intValue());
        } else {
            DosFileAttributes dosAttrs = (DosFileAttributes)attrs;
            stat.setGid(0);
            stat.setUid(0);
            int type = dosAttrs.isSymbolicLink() ? 40960 : (dosAttrs.isDirectory() ? 16384 : 32768);
            stat.setMode(type | (dosAttrs.isReadOnly() ? 256 : 384));
            stat.setNlink(1);
        }
        stat.setDev(17);
        stat.setIno(inodeNumber);
        stat.setRdev(17);
        stat.setSize(attrs.size());
        stat.setGeneration(attrs.lastModifiedTime().toMillis());
        return stat;
    }

    public int access(Subject subject, Inode inode, int mode) throws IOException {
        return mode;
    }

    public Stat getattr(Inode inode) throws IOException {
        long inodeNumber = this.getInodeNumber(inode);
        Path path = this.resolveInode(inodeNumber);
        return this.statPath(path, inodeNumber);
    }

    public void setattr(Inode inode, Stat stat) throws IOException {
        FileTime time;
        if (!IS_UNIX) {
            return;
        }
        long inodeNumber = this.getInodeNumber(inode);
        Path path = this.resolveInode(inodeNumber);
        PosixFileAttributeView attributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        if (stat.isDefined(Stat.StatAttribute.OWNER)) {
            try {
                String uid = String.valueOf(stat.getUid());
                UserPrincipal user = this._lookupService.lookupPrincipalByName(uid);
                attributeView.setOwner(user);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("set uid failed: " + e.getMessage(), e);
            }
        }
        if (stat.isDefined(Stat.StatAttribute.GROUP)) {
            try {
                String gid = String.valueOf(stat.getGid());
                GroupPrincipal group = this._lookupService.lookupPrincipalByGroupName(gid);
                attributeView.setGroup(group);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("set gid failed: " + e.getMessage(), e);
            }
        }
        if (stat.isDefined(Stat.StatAttribute.MODE)) {
            try {
                Files.setAttribute(path, "unix:mode", stat.getMode(), LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("set mode unsupported: " + e.getMessage(), e);
            }
        }
        if (stat.isDefined(Stat.StatAttribute.SIZE)) {
            try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "rw");){
                raf.setLength(stat.getSize());
            }
        }
        if (stat.isDefined(Stat.StatAttribute.ATIME)) {
            try {
                time = FileTime.fromMillis(stat.getCTime());
                Files.setAttribute(path, "unix:lastAccessTime", time, LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("set atime failed: " + e.getMessage(), e);
            }
        }
        if (stat.isDefined(Stat.StatAttribute.MTIME)) {
            try {
                time = FileTime.fromMillis(stat.getMTime());
                Files.setAttribute(path, "unix:lastModifiedTime", time, LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("set mtime failed: " + e.getMessage(), e);
            }
        }
        if (stat.isDefined(Stat.StatAttribute.CTIME)) {
            try {
                time = FileTime.fromMillis(stat.getCTime());
                Files.setAttribute(path, "unix:ctime", time, LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("set ctime failed: " + e.getMessage(), e);
            }
        }
    }

    public nfsace4[] getAcl(Inode inode) throws IOException {
        return new nfsace4[0];
    }

    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
    }

    public boolean hasIOLayout(Inode inode) throws IOException {
        return false;
    }

    public AclCheckable getAclCheckable() {
        return AclCheckable.UNDEFINED_ALL;
    }

    public NfsIdMapping getIdMapper() {
        return this._idMapper;
    }

    public boolean getCaseInsensitive() {
        return true;
    }

    public boolean getCasePreserving() {
        return true;
    }
}

