/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs4j.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.ExportTable;
import org.dcache.nfs.v3.MountServer;
import org.dcache.nfs.v3.NfsServerV3;
import org.dcache.nfs.v4.MDSOperationExecutor;
import org.dcache.nfs.v4.NFSServerV41;
import org.dcache.nfs.v4.OperationExecutor;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.nfs4j.server.LocalFileSystem;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvc;
import org.dcache.oncrpc4j.rpc.OncRpcSvcBuilder;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;

public class SimpleNfsServer
implements Closeable {
    private final OncRpcSvc nfsSvc;
    private final Path root;
    private final int port;
    private final String name;

    public SimpleNfsServer(Path root) {
        this(0, 2049, root, null, null);
    }

    public SimpleNfsServer(int nfsVers, int port, Path root, ExportFile exportFile, String name) {
        try {
            boolean startNfsV4;
            NfsServerV3 nfs3 = null;
            NFSServerV41 nfs4 = null;
            boolean startNfsV3 = nfsVers == 0 || nfsVers == 3;
            boolean bl = startNfsV4 = nfsVers == 0 || nfsVers == 4;
            if (exportFile == null) {
                exportFile = new ExportFile((Reader)new InputStreamReader(SimpleNfsServer.class.getClassLoader().getResourceAsStream("exports")));
            }
            this.port = port;
            if (root == null) {
                root = Files.createTempDirectory(null, new FileAttribute[0]);
            }
            this.root = root;
            if (name == null) {
                name = "nfs@" + this.port;
            }
            this.name = name;
            LocalFileSystem vfs = new LocalFileSystem(this.root, exportFile.exports().collect(Collectors.toList()));
            this.nfsSvc = new OncRpcSvcBuilder().withPort(this.port).withTCP().withAutoPublish().withWorkerThreadIoStrategy().withServiceName(this.name).build();
            if (startNfsV4) {
                nfs4 = new NFSServerV41.Builder().withVfs((VirtualFileSystem)vfs).withOperationExecutor((OperationExecutor)new MDSOperationExecutor()).withExportTable((ExportTable)exportFile).build();
            }
            if (startNfsV3) {
                nfs3 = new NfsServerV3((ExportTable)exportFile, (VirtualFileSystem)vfs);
            }
            MountServer mountd = new MountServer((ExportTable)exportFile, (VirtualFileSystem)vfs);
            if (startNfsV3) {
                this.nfsSvc.register(new OncRpcProgram(100005, 3), (RpcDispatchable)mountd);
                this.nfsSvc.register(new OncRpcProgram(100005, 1), (RpcDispatchable)mountd);
                this.nfsSvc.register(new OncRpcProgram(100003, 3), (RpcDispatchable)nfs3);
            }
            if (startNfsV4) {
                this.nfsSvc.register(new OncRpcProgram(100003, 4), (RpcDispatchable)nfs4);
            }
            this.nfsSvc.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.nfsSvc.stop();
    }

    public Path getRoot() {
        return this.root;
    }

    public int getPort() {
        return this.port;
    }
}

