/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.benchmarks;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvc;
import org.dcache.oncrpc4j.rpc.OncRpcSvcBuilder;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeNone;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrVoid;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.Throughput})
public class TlsOverhead {
    private static final int PROGNUM = 100017;
    private static final int PROGVER = 1;
    @Param(value={"true", "false"})
    private String withTLS;
    private OncRpcSvc svc;
    private OncRpcSvc clnt;
    private RpcCall clntCall;
    private SSLContext sslContext;
    private final RpcDispatchable NULL = call -> call.reply((XdrAble)XdrVoid.XDR_VOID);

    @Setup
    public void setUp() throws IOException, Exception {
        if (Boolean.getBoolean(this.withTLS)) {
            this.sslContext = TlsOverhead.createSslContext();
        }
        this.svc = new OncRpcSvcBuilder().withoutAutoPublish().withTCP().withWorkerThreadIoStrategy().withBindAddress("127.0.0.1").withSelectorThreadPoolSize(1).withWorkerThreadPoolSize(1).withRpcService(new OncRpcProgram(100017, 1), this.NULL).withSSLContext(this.sslContext).withServiceName("svc").build();
        this.svc.start();
        this.clnt = new OncRpcSvcBuilder().withoutAutoPublish().withTCP().withClientMode().withWorkerThreadIoStrategy().withSelectorThreadPoolSize(1).withWorkerThreadPoolSize(1).withSSLContext(this.sslContext).withServiceName("clnt").build();
        this.clnt.start();
        RpcTransport t = this.clnt.connect(this.svc.getInetSocketAddress(6));
        this.clntCall = new RpcCall(100017, 1, (RpcAuth)new RpcAuthTypeNone(), t);
    }

    @TearDown
    public void shutdown() throws IOException {
        this.clnt.stop();
        this.svc.stop();
    }

    @Benchmark
    public XdrAble callOpNull() throws IOException {
        XdrVoid reply = new XdrVoid();
        this.clntCall.call(0, (XdrAble)XdrVoid.XDR_VOID, (XdrAble)reply);
        return reply;
    }

    public static SSLContext createSslContext() throws Exception {
        char[] password = "password".toCharArray();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Certificate certificate = TlsOverhead.generateSelfSignedCert(keyPair);
        Certificate[] certificateChain = new Certificate[]{certificate};
        KeyStore keyStore = TlsOverhead.createEmptyKeystore();
        keyStore.setKeyEntry("private", keyPair.getPrivate(), password, certificateChain);
        keyStore.setCertificateEntry("cert", certificate);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private static Certificate generateSelfSignedCert(KeyPair keyPair) throws GeneralSecurityException, OperatorCreationException {
        X500Name subjectDN;
        long notBefore = System.currentTimeMillis();
        long notAfter = notBefore + TimeUnit.DAYS.toMillis(1L);
        X500Name issuerDN = subjectDN = new X500Name("CN=localhost, O=dCache.org");
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(issuerDN, BigInteger.ONE, new Date(notBefore), new Date(notAfter), subjectDN, subjectPublicKeyInfo);
        String signatureAlgorithm = "SHA256WithRSA";
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(keyPair.getPrivate());
        X509CertificateHolder certificateHolder = certificateBuilder.build(contentSigner);
        return new JcaX509CertificateConverter().getCertificate(certificateHolder);
    }

    private static KeyStore createEmptyKeystore() throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

