/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.benchmarks;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import org.dcache.oncrpc4j.rpc.OncRpcClient;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvc;
import org.dcache.oncrpc4j.rpc.OncRpcSvcBuilder;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeNone;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrVoid;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
public class RpcPing {
    private static final int PROG_NUMBER = 100017;
    private static final int PROG_VERS = 1;
    private static final OncRpcProgram prog = new OncRpcProgram(100017, 1);
    private OncRpcSvc svc;
    private OncRpcClient rpcClient;
    private RpcCall call;

    @Setup
    public void setUp() throws IOException {
        this.svc = new OncRpcSvcBuilder().withTCP().withoutAutoPublish().withPort(0).withSameThreadIoStrategy().withRpcService(prog, call -> call.reply((XdrAble)XdrVoid.XDR_VOID)).build();
        this.svc.start();
        InetSocketAddress socketAddress = this.svc.getInetSocketAddress(6);
        this.rpcClient = new OncRpcClient(socketAddress, 6);
        RpcTransport transport = this.rpcClient.connect();
        this.call = new RpcCall(prog.getNumber(), prog.getVersion(), (RpcAuth)new RpcAuthTypeNone(), transport);
    }

    @Benchmark
    public XdrAble rpcPingSingle() throws IOException, ExecutionException, InterruptedException {
        return (XdrAble)this.call.call(0, (XdrAble)XdrVoid.XDR_VOID, XdrVoid.class).get();
    }

    @TearDown
    public void tearDown() throws IOException {
        this.rpcClient.close();
        this.svc.stop();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(RpcPing.class.getSimpleName()).build();
        new Runner(opt).run();
    }
}

