/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.Xdr;
import org.dcache.xdr.XdrTransport;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyXdrTransport
implements XdrTransport {
    private final Connection<InetSocketAddress> _connection;
    private final ReplyQueue _replyQueue;
    private final InetSocketAddress _localAddress;
    private final InetSocketAddress _remoteAddress;
    private static final Logger _log = LoggerFactory.getLogger(GrizzlyXdrTransport.class);

    public GrizzlyXdrTransport(Connection<InetSocketAddress> connection, ReplyQueue replyQueue) {
        this(connection, connection.getPeerAddress(), replyQueue);
    }

    public GrizzlyXdrTransport(Connection<InetSocketAddress> connection, InetSocketAddress remoteAddress, ReplyQueue replyQueue) {
        this._connection = connection;
        this._replyQueue = replyQueue;
        this._localAddress = this._connection.getLocalAddress();
        this._remoteAddress = remoteAddress;
    }

    @Override
    public void send(Xdr xdr) throws IOException {
        final Buffer buffer = xdr.asBuffer();
        buffer.allowBufferDispose(true);
        this._connection.write(this._remoteAddress, buffer, new EmptyCompletionHandler<WriteResult<WritableMessage, InetSocketAddress>>(){

            @Override
            public void failed(Throwable throwable) {
                _log.error("Failed to send RPC message: xid=0x{} remote={} : {}", Integer.toHexString(buffer.getInt(0)), GrizzlyXdrTransport.this._connection.getPeerAddress(), throwable.getMessage());
            }
        });
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this._localAddress;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this._remoteAddress;
    }

    @Override
    public ReplyQueue getReplyQueue() {
        return this._replyQueue;
    }

    @Override
    public XdrTransport getPeerTransport() {
        return new GrizzlyXdrTransport(this._connection, this.getReplyQueue());
    }

    public String toString() {
        return this.getRemoteSocketAddress() + " <=> " + this.getLocalSocketAddress();
    }
}

