/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.xdr.MismatchInfo;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.RpcAuth;
import org.dcache.xdr.RpcCredential;
import org.dcache.xdr.RpcMessage;
import org.dcache.xdr.RpcMismatchReply;
import org.dcache.xdr.RpcReply;
import org.dcache.xdr.Xdr;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrTransport;
import org.dcache.xdr.XdrVoid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCall {
    private static final Logger _log = LoggerFactory.getLogger(RpcCall.class);
    private static final AtomicInteger NEXT_XID = new AtomicInteger(0);
    private int _xid;
    private static final int RPCVERS = 2;
    private int _prog;
    private int _version;
    private int _proc;
    private int _rpcvers;
    private RpcAuth _cred;
    private final XdrTransport _transport;
    private final Xdr _xdr;

    public RpcCall(int prog, int ver, RpcAuth cred, XdrTransport transport) {
        this(prog, ver, cred, new Xdr(1024), transport);
    }

    public RpcCall(int prog, int ver, RpcAuth cred, Xdr xdr, XdrTransport transport) {
        this._prog = prog;
        this._version = ver;
        this._cred = cred;
        this._transport = transport;
        this._xdr = xdr;
        this._proc = 0;
    }

    public RpcCall(int xid, Xdr xdr, XdrTransport transport) {
        this._xid = xid;
        this._xdr = xdr;
        this._transport = transport;
    }

    public RpcCall(int xid, int prog, int ver, int proc, RpcAuth cred, Xdr xdr, XdrTransport transport) {
        this._xid = xid;
        this._prog = prog;
        this._version = ver;
        this._proc = proc;
        this._cred = cred;
        this._xdr = xdr;
        this._transport = transport;
        this._rpcvers = 2;
    }

    public void accept() throws IOException, OncRpcException {
        this._rpcvers = this._xdr.xdrDecodeInt();
        if (this._rpcvers != 2) {
            throw new RpcMismatchReply(this._rpcvers, 2);
        }
        this._prog = this._xdr.xdrDecodeInt();
        this._version = this._xdr.xdrDecodeInt();
        this._proc = this._xdr.xdrDecodeInt();
        this._cred = RpcCredential.decode(this._xdr);
    }

    public int getProgram() {
        return this._prog;
    }

    public int getProgramVersion() {
        return this._version;
    }

    public int getProcedure() {
        return this._proc;
    }

    public RpcAuth getCredential() {
        return this._cred;
    }

    public XdrTransport getTransport() {
        return this._transport;
    }

    public int getXid() {
        return this._xid;
    }

    public Xdr getXdr() {
        return this._xdr;
    }

    public String toString() {
        return String.format("RPCv%d call: program=%d, version=%d, procedure=%d", this._rpcvers, this._prog, this._version, this._proc);
    }

    public void reject(int status, XdrAble reason) {
        Xdr xdr = this._xdr;
        try {
            RpcMessage replyMessage = new RpcMessage(this._xid, 1);
            xdr.beginEncoding();
            replyMessage.xdrEncode(this._xdr);
            xdr.xdrEncodeInt(1);
            xdr.xdrEncodeInt(status);
            reason.xdrEncode(this._xdr);
            xdr.endEncoding();
            this._transport.send(xdr);
        }
        catch (OncRpcException e) {
            _log.warn("Xdr exception: ", e);
        }
        catch (IOException e) {
            _log.error("Failed send reply: ", e);
        }
    }

    public void reply(XdrAble reply) {
        this.acceptedReply(0, reply);
    }

    public void acceptedReply(int state, XdrAble reply) {
        Xdr xdr = this._xdr;
        try {
            RpcMessage replyMessage = new RpcMessage(this._xid, 1);
            xdr.beginEncoding();
            replyMessage.xdrEncode(this._xdr);
            xdr.xdrEncodeInt(0);
            this._cred.getVerifier().xdrEncode(xdr);
            xdr.xdrEncodeInt(state);
            reply.xdrEncode(xdr);
            xdr.endEncoding();
            this._transport.send(xdr);
        }
        catch (OncRpcException e) {
            _log.warn("Xdr exception: ", e);
        }
        catch (IOException e) {
            _log.error("Failed send reply: ", e);
        }
    }

    public void retrieveCall(XdrAble args) throws OncRpcException, IOException {
        args.xdrDecode(this._xdr);
        this._xdr.endDecoding();
    }

    public void failProgramMismatch(int min, int max) {
        this.acceptedReply(2, new MismatchInfo(min, max));
    }

    public void failProgramUnavailable() {
        this.acceptedReply(1, XdrVoid.XDR_VOID);
    }

    public void failProcedureUnavailable() {
        this.acceptedReply(3, XdrVoid.XDR_VOID);
    }

    public void failRpcGarbage() {
        this.acceptedReply(4, XdrVoid.XDR_VOID);
    }

    public void failRpcSystem() {
        this.acceptedReply(5, XdrVoid.XDR_VOID);
    }

    public void call(int procedure, XdrAble args, CompletionHandler<RpcReply, XdrTransport> callback, long timeoutValue, TimeUnit timeoutUnits, RpcAuth auth) throws IOException {
        this.callInternal(procedure, args, callback, timeoutValue, timeoutUnits, auth);
    }

    public void call(int procedure, XdrAble args, CompletionHandler<RpcReply, XdrTransport> callback, long timeoutValue, TimeUnit timeoutUnits) throws IOException {
        this.callInternal(procedure, args, callback, timeoutValue, timeoutUnits, null);
    }

    public void call(int procedure, XdrAble args, CompletionHandler<RpcReply, XdrTransport> callback, RpcAuth auth) throws IOException {
        this.callInternal(procedure, args, callback, 0L, null, auth);
    }

    public void call(int procedure, XdrAble args, CompletionHandler<RpcReply, XdrTransport> callback) throws IOException {
        this.callInternal(procedure, args, callback, 0L, null, null);
    }

    private int callInternal(int procedure, XdrAble args, CompletionHandler<RpcReply, XdrTransport> callback, long timeoutValue, TimeUnit timeoutUnits, RpcAuth auth) throws IOException {
        int xid = NEXT_XID.incrementAndGet();
        Xdr xdr = new Xdr(1024);
        xdr.beginEncoding();
        RpcMessage rpcMessage = new RpcMessage(xid, 0);
        rpcMessage.xdrEncode(xdr);
        xdr.xdrEncodeInt(2);
        xdr.xdrEncodeInt(this._prog);
        xdr.xdrEncodeInt(this._version);
        xdr.xdrEncodeInt(procedure);
        if (auth != null) {
            auth.xdrEncode(xdr);
        } else {
            this._cred.xdrEncode(xdr);
        }
        args.xdrEncode(xdr);
        xdr.endEncoding();
        ReplyQueue replyQueue = this._transport.getReplyQueue();
        if (callback != null) {
            replyQueue.registerKey(xid, callback, timeoutValue, timeoutUnits);
        } else {
            replyQueue.assertConnected();
        }
        this._transport.send(xdr);
        return xid;
    }

    public <T extends XdrAble> Future<T> call(int procedure, XdrAble args, Class<T> type, RpcAuth auth) throws IOException {
        try {
            XdrAble result = (XdrAble)type.newInstance();
            return this.getCallFuture(procedure, args, result, 0L, null, auth);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to create in instance of " + type, e);
        }
    }

    public <T extends XdrAble> Future<T> call(int procedure, XdrAble args, Class<T> type) throws IOException {
        return this.call(procedure, args, type, null);
    }

    public void call(int procedure, XdrAble args, XdrAble result, long timeoutValue, TimeUnit timeoutUnits, RpcAuth auth) throws IOException, TimeoutException {
        try {
            Future<XdrAble> future = this.getCallFuture(procedure, args, result, timeoutValue, timeoutUnits, auth);
            future.get();
        }
        catch (InterruptedException e) {
            InterruptedIOException ioe = new InterruptedIOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (ExecutionException e) {
            Throwable t = Throwables.getRootCause(e);
            Throwables.propagateIfInstanceOf(t, OncRpcException.class);
            Throwables.propagateIfInstanceOf(t, IOException.class);
            Throwables.propagateIfInstanceOf(t, TimeoutException.class);
            throw new IOException(t);
        }
    }

    public void call(int procedure, XdrAble args, XdrAble result, long timeoutValue, TimeUnit timeoutUnits) throws IOException, TimeoutException {
        this.call(procedure, args, result, timeoutValue, timeoutUnits, null);
    }

    public void call(int procedure, XdrAble args, XdrAble result, RpcAuth auth) throws IOException {
        try {
            this.call(procedure, args, result, 0L, null, auth);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    public void call(int procedure, XdrAble args, XdrAble result) throws IOException {
        try {
            this.call(procedure, args, result, 0L, null, null);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    private <T extends XdrAble> Future<T> getCallFuture(int procedure, XdrAble args, final T result, long timeoutValue, TimeUnit timeoutUnits, RpcAuth auth) throws IOException {
        final SettableFuture future = SettableFuture.create();
        CompletionHandler<RpcReply, XdrTransport> callback = new CompletionHandler<RpcReply, XdrTransport>(){

            @Override
            public void completed(RpcReply reply, XdrTransport attachment) {
                try {
                    reply.getReplyResult(result);
                    future.set(result);
                }
                catch (IOException e) {
                    this.failed((Throwable)e, attachment);
                }
            }

            @Override
            public void failed(Throwable exc, XdrTransport attachment) {
                future.setException(exc);
            }
        };
        int xid = this.callInternal(procedure, args, callback, timeoutValue, timeoutUnits, auth);
        return timeoutValue > 0L ? future : new TimeoutAwareFuture(future, xid);
    }

    private class TimeoutAwareFuture<T>
    implements Future<T> {
        private final Future<T> delegate;
        private final int xid;

        public TimeoutAwareFuture(Future<T> delegate, int xid) {
            this.delegate = delegate;
            this.xid = xid;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                boolean bl = this.delegate.cancel(mayInterruptIfRunning);
                return bl;
            }
            finally {
                if (mayInterruptIfRunning) {
                    this.unregisterXid();
                }
            }
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                T t = this.delegate.get();
                return t;
            }
            finally {
                this.unregisterXid();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                T t = this.delegate.get(timeout, unit);
                return t;
            }
            finally {
                this.unregisterXid();
            }
        }

        private void unregisterXid() {
            RpcCall.this._transport.getReplyQueue().get(this.xid);
        }
    }
}

