/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.security.auth.Subject;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.RpcDispatchable;
import org.dcache.xdr.RpcException;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcDispatcher
extends BaseFilter {
    private static final Logger _log = LoggerFactory.getLogger(RpcDispatcher.class);
    private final Map<OncRpcProgram, RpcDispatchable> _programs;
    private final ExecutorService _asyncExecutorService;
    private final boolean _withSubjectPropagation;

    public RpcDispatcher(ExecutorService executor, Map<OncRpcProgram, RpcDispatchable> programs, boolean withSubjectPropagation) throws NullPointerException {
        this._programs = Objects.requireNonNull(programs, "Programs is NULL");
        this._asyncExecutorService = Objects.requireNonNull(executor, "ExecutorService is NULL");
        this._withSubjectPropagation = withSubjectPropagation;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        final RpcCall call = (RpcCall)ctx.getMessage();
        int prog = call.getProgram();
        int vers = call.getProgramVersion();
        int proc = call.getProcedure();
        _log.debug("processing request {}", (Object)call);
        final RpcDispatchable program = this._programs.get(new OncRpcProgram(prog, vers));
        if (program == null) {
            call.failProgramUnavailable();
        } else {
            this._asyncExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (RpcDispatcher.this._withSubjectPropagation) {
                            Subject subject = call.getCredential().getSubject();
                            try {
                                Subject.doAs(subject, () -> {
                                    program.dispatchOncRpcCall(call);
                                    return null;
                                });
                            }
                            catch (PrivilegedActionException e) {
                                Throwable t = e.getCause();
                                Throwables.propagateIfInstanceOf(t, IOException.class);
                                Throwables.propagate(t);
                            }
                        } else {
                            program.dispatchOncRpcCall(call);
                        }
                    }
                    catch (RpcException e) {
                        call.reject(e.getStatus(), e.getRpcReply());
                        _log.warn("Failed to process RPC request: {}", (Object)e.getMessage());
                    }
                    catch (OncRpcException e) {
                        call.failRpcGarbage();
                        _log.warn("Failed to process RPC request: {}", (Object)e.getMessage());
                    }
                    catch (IOException e) {
                        call.failRpcGarbage();
                        _log.warn("Failed to process RPC request: {}", (Object)e.getMessage());
                    }
                    catch (RuntimeException e) {
                        _log.error("Failed to process RPC request:", e);
                        call.failRpcSystem();
                        throw e;
                    }
                }

                public String toString() {
                    return call.toString();
                }
            });
        }
        return ctx.getInvokeAction();
    }
}

