/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr.portmap;

import java.io.IOException;
import org.dcache.xdr.IpProtocolType;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrDecodingStream;
import org.dcache.xdr.XdrEncodingStream;
import org.dcache.xdr.netid;
import org.dcache.xdr.portmap.mapping;

public class rpcb
implements XdrAble {
    private int _prog;
    private int _vers;
    private String _netid;
    private String _addr;
    private String _owner;

    public rpcb() {
    }

    public rpcb(mapping old) {
        this._prog = old.getProg();
        this._vers = old.getVers();
        this._netid = IpProtocolType.toString(old.getProt());
        this._addr = netid.toString(old.getPort());
        this._owner = "unspecified";
    }

    public rpcb(int prog, int vers, String netid2, String addr, String owner) {
        this._prog = prog;
        this._vers = vers;
        this._netid = netid2;
        this._addr = addr;
        this._owner = owner;
    }

    public int getProg() {
        return this._prog;
    }

    public int getVers() {
        return this._vers;
    }

    public String getNetid() {
        return this._netid;
    }

    public String getOwner() {
        return this._owner;
    }

    @Override
    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this._prog = xdr.xdrDecodeInt();
        this._vers = xdr.xdrDecodeInt();
        this._netid = xdr.xdrDecodeString();
        this._addr = xdr.xdrDecodeString();
        this._owner = xdr.xdrDecodeString();
    }

    @Override
    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        xdr.xdrEncodeInt(this._prog);
        xdr.xdrEncodeInt(this._vers);
        xdr.xdrEncodeString(this._netid);
        xdr.xdrEncodeString(this._addr);
        xdr.xdrEncodeString(this._owner);
    }

    public String toString() {
        return String.format("prog: %d, vers: %d, netid: %s, addr: %s, owner: %s", this._prog, this._vers, this._netid, this._addr, this._owner);
    }

    public mapping toMapping() {
        return new mapping(this._prog, this._vers, netid.idOf(this._netid), netid.getPort(this._addr));
    }

    boolean match(rpcb query) {
        return query._prog == this._prog && query._vers == this._vers && query._netid.equals(this._netid);
    }
}

