/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.EOFException;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.xdr.RpcReply;
import org.dcache.xdr.XdrTransport;

public class ReplyQueue {
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "timeout thread #" + this.counter.incrementAndGet() + " for ReplyQueue " + ReplyQueue.this);
            t.setDaemon(true);
            return t;
        }
    });
    private final ConcurrentMap<Integer, HandlerTimeoutPair> _queue = new ConcurrentHashMap<Integer, HandlerTimeoutPair>();
    private volatile boolean _isConnected = true;

    public void registerKey(int key, CompletionHandler<RpcReply, XdrTransport> callback) throws EOFException {
        this.registerKey(key, callback, 0L, null);
    }

    public void registerKey(final int key, CompletionHandler<RpcReply, XdrTransport> callback, final long timeoutValue, final TimeUnit timeoutUnits) throws EOFException {
        if (!this._isConnected) {
            throw new EOFException("Disconnected");
        }
        ScheduledFuture<?> scheduledTimeout = null;
        if (timeoutValue > 0L && timeoutUnits != null) {
            scheduledTimeout = this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    CompletionHandler<RpcReply, XdrTransport> handler = ReplyQueue.this.get(key);
                    if (handler != null) {
                        handler.failed(new TimeoutException("did not get a response within " + timeoutValue + " " + (Object)((Object)timeoutUnits)), null);
                    }
                }
            }, timeoutValue, timeoutUnits);
        }
        this._queue.put(key, new HandlerTimeoutPair(callback, scheduledTimeout));
    }

    public synchronized void handleDisconnect() {
        this._isConnected = false;
        EOFException eofException = new EOFException("Disconnected");
        for (HandlerTimeoutPair handler : this._queue.values()) {
            handler.handler.failed(eofException, null);
        }
        for (HandlerTimeoutPair pair : this._queue.values()) {
            ScheduledFuture timeoutFuture = pair.scheduledTimeout;
            if (timeoutFuture == null) continue;
            timeoutFuture.cancel(false);
        }
        this._queue.clear();
        this.executorService.shutdown();
    }

    public CompletionHandler<RpcReply, XdrTransport> get(int key) {
        HandlerTimeoutPair pair = (HandlerTimeoutPair)this._queue.remove(key);
        if (pair != null) {
            if (pair.scheduledTimeout != null) {
                pair.scheduledTimeout.cancel(false);
            }
            return pair.handler;
        }
        return null;
    }

    private static class HandlerTimeoutPair {
        private final CompletionHandler<RpcReply, XdrTransport> handler;
        private final ScheduledFuture<?> scheduledTimeout;

        public HandlerTimeoutPair(CompletionHandler<RpcReply, XdrTransport> handler, ScheduledFuture<?> scheduledTimeout) {
            this.handler = handler;
            this.scheduledTimeout = scheduledTimeout;
        }
    }
}

