/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.jarpcbind;

import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.OncRpcSvc;
import org.dcache.xdr.OncRpcSvcBuilder;
import org.dcache.xdr.portmap.OncRpcbindServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final Object LOCK = new Object();
    private static volatile boolean on = true;
    private static volatile Thread mainThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        mainThread = Thread.currentThread();
        logger.info("starting up");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.info("interrupt received, shutting down");
                Object object = LOCK;
                synchronized (object) {
                    on = false;
                    LOCK.notifyAll();
                    mainThread.interrupt();
                }
                try {
                    mainThread.join();
                }
                catch (InterruptedException e) {
                    logger.error("interrupted waiting for graceful shutdown", e);
                }
                logger.info("exiting");
            }
        });
        OncRpcbindServer rpcbind = new OncRpcbindServer();
        OncRpcSvc server = new OncRpcSvcBuilder().withPort(111).withTCP().withUDP().withSameThreadIoStrategy().withoutAutoPublish().build();
        server.register(new OncRpcProgram(100000, 2), rpcbind);
        server.start();
        logger.info("up and running");
        Object object = LOCK;
        synchronized (object) {
            while (on) {
                try {
                    LOCK.wait();
                }
                catch (InterruptedException e) {
                    if (!on) continue;
                    logger.error("spurious interruption", e);
                }
            }
        }
        logger.info("shutting down");
    }
}

