/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDeclaration;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenEnDecodingInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenEnum;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParamInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParser;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenParserException;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProcedureInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenProgramInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenSHA;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenScanner;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenStruct;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnion;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnionArm;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenVersionInfo;
import org.acplt.oncrpc.apps.jrpcgen.cup_runtime.Symbol;

public class jrpcgen {
    public static final String VERSION = "1.0.7+";
    public static final int PARAMS_VOID = 0;
    public static final int PARAMS_SINGLE = 1;
    public static final int PARAMS_SINGLE_BASETYPE = 2;
    public static final int PARAMS_MORE = 3;
    public static final String startDate = new SimpleDateFormat().format(new Date());
    public static Map globalIdentifiers = new HashMap();
    public static boolean noBackups = false;
    public static List<JrpcgenProgramInfo> programInfos = null;
    public static boolean debug = false;
    public static boolean verbose = false;
    public static boolean parseOnly = false;
    public static File xFile = null;
    public static File destinationDir = new File(".");
    public static Writer currentFileWriter = null;
    public static PrintWriter currentPrintWriter = null;
    public static String currentFilename = null;
    public static String packageName = null;
    public static String baseClassname = null;
    public static boolean noClient = false;
    public static boolean noServer = false;
    public static String serverClass = null;
    public static String clientClass = null;
    public static boolean makeSerializable = false;
    public static boolean makeBean = false;
    public static boolean initStrings = false;
    public static boolean generateSyncClient = true;
    public static boolean generateAsyncFutureClient = false;
    public static boolean generateAsyncCallbackClient = false;
    public static boolean generateOneWayClient = false;
    public static boolean generateTimeoutSupport = false;
    public static boolean generatePerCallAuthSupport = false;
    private static String[] baseTypes = new String[]{"void", "boolean", "byte", "short", "int", "long", "float", "double", "String"};

    public static void printHelp() {
        System.out.println("Usage: jrpcgen [-options] x-file");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("  -c <classname>  specify class name of client proxy stub");
        System.out.println("  -d <dir>        specify directory where to place generated source code files");
        System.out.println("  -p <package>    specify package name for generated source code files");
        System.out.println("  -s <classname>  specify class name of server proxy stub");
        System.out.println("  -ser            tag generated XDR classes as serializable");
        System.out.println("  -bean           generate accessors for usage as bean, implies -ser");
        System.out.println("  -noclamp        do not clamp version number in client method stubs");
        System.out.println("  -initstrings    initialize all strings to be empty instead of null");
        System.out.println("  -nobackup       do not make backups of old source code files");
        System.out.println("  -noclient       do not create client proxy stub");
        System.out.println("  -noserver       do not create server proxy stub");
        System.out.println("  -parseonly      parse x-file only but do not create source code files");
        System.out.println("  -asyncfuture    generate async client methods that return Futures");
        System.out.println("  -asynccallback  generate async client methods that accept callback handlers");
        System.out.println("  -oneway         generate client methods that are one-way");
        System.out.println("  -nosync         do not generate sync client methods (which are generated by default)");
        System.out.println("  -timeouts       generate methods that accept a timeout argument (except one-way methods)");
        System.out.println("  -percallauth    generate methods that accept an auth argument (null for default)");
        System.out.println("  -verbose        enable verbose output about what jrpcgen is doing");
        System.out.println("  -version        print jrpcgen version and exit");
        System.out.println("  -debug          enables printing of diagnostic messages");
        System.out.println("  -? -help        print this help message and exit");
        System.out.println("  --              end options");
        System.out.println();
    }

    public static PrintWriter createJavaSourceFile(String classname) {
        return jrpcgen.createJavaSourceFile(classname, true);
    }

    public static PrintWriter createJavaSourceFile(String classname, boolean emitImports) {
        PrintWriter out;
        File file;
        String filename = classname + ".java";
        if (debug) {
            System.out.println("Generating source code for \"" + filename + "\" in \"" + destinationDir + "\"");
        }
        if ((file = new File(destinationDir, filename)).exists() && !noBackups) {
            File oldBackup;
            if (!file.isFile()) {
                System.err.println("error: source file \"" + filename + "\"already exists and is not a regular file");
                System.exit(1);
            }
            if ((oldBackup = new File(destinationDir, filename + "~")).isFile()) {
                oldBackup.delete();
            } else if (oldBackup.exists()) {
                System.err.println("error: backup source file \"" + filename + "~\" is not a regular file");
                System.exit(1);
            }
            if (!file.renameTo(new File(destinationDir, filename + "~"))) {
                System.err.println("error: can not rename old source code file \"" + filename + "\"");
                System.exit(1);
            }
            if (verbose) {
                System.out.println("Saved old source code file as \"" + filename + "~\"");
            }
        }
        try {
            currentFileWriter = new FileWriter(file);
        }
        catch (IOException e) {
            System.err.println("error: can not create \"" + filename + "\": " + e.getLocalizedMessage());
            System.exit(1);
        }
        if (verbose) {
            System.out.print("Creating source code file \"" + filename + "\"...");
        }
        currentFilename = filename;
        currentPrintWriter = out = new PrintWriter(currentFileWriter, true);
        out.println("/*");
        out.println(" * Automatically generated by jrpcgen 1.0.7+ on " + startDate);
        out.println(" * jrpcgen is part of the \"Remote Tea\" ONC/RPC package for Java");
        out.println(" * See http://remotetea.sourceforge.net for details");
        out.println(" *");
        out.println(" * This version of jrpcgen adopted by dCache project");
        out.println(" * See http://www.dCache.ORG for details");
        out.println(" */");
        if (packageName != null && packageName.length() > 0) {
            out.println("package " + packageName + ";");
        }
        if (emitImports) {
            out.println("import org.dcache.oncrpc4j.rpc.*;");
            out.println("import org.dcache.oncrpc4j.rpc.net.*;");
            out.println("import org.dcache.oncrpc4j.xdr.*;");
            out.println("import java.io.IOException;");
            out.println();
        }
        return out;
    }

    public static JrpcgenSHA createSHA(String classname) {
        JrpcgenSHA hash = new JrpcgenSHA();
        if (packageName != null && packageName.length() > 0) {
            hash.update(packageName + "." + classname);
        } else {
            hash.update(classname);
        }
        return hash;
    }

    public static void closeJavaSourceFile() {
        currentPrintWriter.println("// End of " + currentFilename);
        if (verbose) {
            System.out.println();
        }
        try {
            currentPrintWriter.close();
            currentFileWriter.close();
        }
        catch (IOException e) {
            System.err.println("Can not close source code file: " + e.getLocalizedMessage());
        }
    }

    public static void dumpConstantAndDependency(JrpcgenConst c, List<String> declarations, Set<String> imports) {
        JrpcgenConst dc;
        if (c.dontTraverseAnyMore) {
            return;
        }
        c.dontTraverseAnyMore = true;
        String dependencyIdentifier = c.getDependencyIdentifier();
        if (dependencyIdentifier != null && (dc = (JrpcgenConst)globalIdentifiers.get(dependencyIdentifier)) != null) {
            if (!c.enclosure.equalsIgnoreCase(dc.enclosure)) {
                jrpcgen.translateConstant(c, declarations, imports, dc.enclosure + "." + c.value);
                return;
            }
            jrpcgen.dumpConstantAndDependency(dc, declarations, imports);
        }
        jrpcgen.translateConstant(c, declarations, imports, null);
    }

    public static void translateConstant(JrpcgenConst constDecl, List<String> declarations, Set<String> imports, String valueOverride) {
        BigInteger maxIntBound;
        BigInteger value;
        int radix;
        String valueSansPrefix;
        String rawValue = constDecl.resolveValue();
        String str = rawValue.toLowerCase(Locale.ROOT);
        boolean hexOrOctal = true;
        if (str.startsWith("0x")) {
            valueSansPrefix = rawValue.substring(2);
            radix = 16;
            value = new BigInteger(str.substring(2), 16);
        } else if (str.length() > 1 && str.startsWith("0")) {
            valueSansPrefix = rawValue.substring(1);
            radix = 8;
            value = new BigInteger(str.substring(1), 8);
        } else {
            hexOrOctal = false;
            valueSansPrefix = rawValue;
            radix = 10;
            value = new BigInteger(str, 10);
        }
        BigInteger maxLongBound = hexOrOctal ? new BigInteger("FFFFFFFFFFFFFFFF", 16) : BigInteger.valueOf(Long.MAX_VALUE);
        BigInteger bigInteger = maxIntBound = hexOrOctal ? new BigInteger("FFFFFFFF", 16) : BigInteger.valueOf(Integer.MAX_VALUE);
        if (value.compareTo(maxLongBound) > 0 || value.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            imports.add("import " + BigInteger.class.getCanonicalName() + ";");
            String val = valueOverride != null ? valueOverride : "new BigInteger(\"" + valueSansPrefix + "\", " + radix + ")";
            declarations.add("    public static final BigInteger " + constDecl.identifier + " = " + val + ";");
        } else if (value.compareTo(maxIntBound) > 0 || value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            String val = valueOverride != null ? valueOverride : rawValue + "L";
            declarations.add("    public static final long " + constDecl.identifier + " = " + val + ";");
        } else {
            String val = valueOverride != null ? valueOverride : rawValue;
            declarations.add("    public static final int " + constDecl.identifier + " = " + val + ";");
        }
    }

    public static void dumpConstants() {
        PrintWriter out = jrpcgen.createJavaSourceFile(baseClassname, false);
        out.println("/**");
        out.println(" * A collection of constants used by the \"" + baseClassname + "\" ONC/RPC program.");
        out.println(" */");
        ArrayList<String> declarations = new ArrayList<String>();
        HashSet<String> imports = new HashSet<String>();
        for (Object o : globalIdentifiers.values()) {
            if (!(o instanceof JrpcgenConst)) continue;
            JrpcgenConst c = (JrpcgenConst)o;
            if (!baseClassname.equals(c.enclosure)) continue;
            jrpcgen.dumpConstantAndDependency(c, declarations, imports);
        }
        if (!imports.isEmpty()) {
            out.println("");
            for (String importLine : imports) {
                out.println(importLine);
            }
            out.println("");
        }
        out.println("public interface " + baseClassname + " {");
        for (String declLine : declarations) {
            out.println(declLine);
        }
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpEnum(JrpcgenEnum e) {
        PrintWriter out = jrpcgen.createJavaSourceFile(e.identifier, false);
        out.println("/**");
        out.println(" * Enumeration (collection of constants).");
        out.println(" */");
        out.println("public interface " + e.identifier + " {");
        out.println();
        Enumeration enums = e.enums.elements();
        while (enums.hasMoreElements()) {
            JrpcgenConst c = (JrpcgenConst)enums.nextElement();
            ArrayList<String> declLines = new ArrayList<String>();
            Set<String> imports = Collections.emptySet();
            jrpcgen.dumpConstantAndDependency(c, declLines, imports);
            for (String line : declLines) {
                out.println(line);
            }
        }
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static String xdrBaseType(String type) {
        int size = baseTypes.length;
        if ("opaque".compareTo(type) == 0) {
            type = "byte";
        }
        for (int idx = 0; idx < size; ++idx) {
            if (baseTypes[idx].compareTo(type) != 0) continue;
            return "Xdr" + type.substring(0, 1).toUpperCase() + type.substring(1);
        }
        return null;
    }

    public static JrpcgenEnDecodingInfo baseEnDecodingSyllable(JrpcgenDeclaration decl) {
        Object o;
        String syllable = decl.type;
        boolean isBase = false;
        int size = baseTypes.length;
        String type = decl.type;
        if ("opaque".compareTo(type) == 0) {
            type = "byte";
        }
        for (int idx = 0; idx < size; ++idx) {
            if (baseTypes[idx].compareTo(type) != 0) continue;
            isBase = true;
            syllable = syllable.substring(0, 1).toUpperCase() + syllable.substring(1);
            break;
        }
        if (!isBase && (o = globalIdentifiers.get(decl.type)) instanceof JrpcgenEnum) {
            isBase = true;
            syllable = "Int";
        }
        if (isBase) {
            String encodingOpts = null;
            String decodingOpts = null;
            if (decl.kind == 1 || decl.kind == 2) {
                if ("opaque".equals(decl.type)) {
                    if (decl.kind == 1) {
                        syllable = "Opaque";
                        encodingOpts = jrpcgen.checkForEnumValue(decl.size);
                        decodingOpts = jrpcgen.checkForEnumValue(decl.size);
                    } else {
                        syllable = "DynamicOpaque";
                        encodingOpts = null;
                        decodingOpts = null;
                    }
                } else if (!"String".equals(decl.type)) {
                    if (decl.kind == 1) {
                        syllable = syllable + "Fixed";
                        encodingOpts = jrpcgen.checkForEnumValue(decl.size);
                        decodingOpts = jrpcgen.checkForEnumValue(decl.size);
                    }
                    syllable = syllable + "Vector";
                }
            }
            return new JrpcgenEnDecodingInfo(syllable, encodingOpts, decodingOpts);
        }
        return null;
    }

    public static String codingMethod(JrpcgenDeclaration decl, boolean encode) {
        return jrpcgen.codingMethod(decl, encode, null);
    }

    public static String codingMethod(JrpcgenDeclaration decl, boolean encode, String oref) {
        if (decl.identifier == null) {
            return "";
        }
        StringBuilder code = new StringBuilder();
        JrpcgenEnDecodingInfo data = jrpcgen.baseEnDecodingSyllable(decl);
        oref = oref == null ? "" : oref + ".";
        if (data != null) {
            if (encode) {
                code.append("        xdr.xdrEncode");
                code.append(data.syllable);
                code.append("(");
                code.append(oref).append(decl.identifier);
                if (data.encodingOptions != null) {
                    code.append(", ");
                    code.append(data.encodingOptions);
                }
                code.append(");\n");
            } else {
                code.append("        ");
                code.append(oref).append(decl.identifier);
                code.append(" = xdr.xdrDecode");
                code.append(data.syllable);
                code.append("(");
                if (data.decodingOptions != null) {
                    code.append(data.decodingOptions);
                }
                code.append(");\n");
            }
            return code.toString();
        }
        if (decl.kind == 0) {
            code.append("        ");
            if (encode) {
                code.append(oref).append(decl.identifier);
                code.append(".xdrEncode(xdr);\n");
            } else {
                code.append(oref).append(decl.identifier);
                code.append(" = new ");
                code.append(decl.type);
                code.append("(xdr);\n");
            }
            return code.toString();
        }
        if (decl.kind == 3) {
            code.append("        ");
            if (encode) {
                code.append("if ( ");
                code.append(oref).append(decl.identifier);
                code.append(" != null ) { ");
                code.append("xdr.xdrEncodeBoolean(true); ");
                code.append(oref).append(decl.identifier);
                code.append(".xdrEncode(xdr);");
                code.append(" } else { ");
                code.append("xdr.xdrEncodeBoolean(false);");
                code.append(" };\n");
            } else {
                code.append(oref).append(decl.identifier);
                code.append(" = xdr.xdrDecodeBoolean() ? new ");
                code.append(decl.type);
                code.append("(xdr) : null;\n");
            }
            return code.toString();
        }
        if (encode) {
            code.append("        { ");
            code.append("int $size = ");
            if (decl.kind == 2) {
                code.append(oref).append(decl.identifier);
                code.append(".length");
            } else {
                code.append(jrpcgen.checkForEnumValue(decl.size));
            }
            code.append("; ");
            if (decl.kind == 2) {
                code.append("xdr.xdrEncodeInt($size); ");
            }
            code.append("for ( int $idx = 0; $idx < $size; ++$idx ) { ");
            code.append(oref).append(decl.identifier);
            code.append("[$idx].xdrEncode(xdr); ");
            code.append("} }\n");
        } else {
            code.append("        { ");
            code.append("int $size = ");
            if (decl.kind == 2) {
                code.append("xdr.xdrDecodeInt()");
            } else {
                code.append(jrpcgen.checkForEnumValue(decl.size));
            }
            code.append("; ");
            code.append(oref).append(decl.identifier);
            code.append(" = new ");
            code.append(decl.type);
            code.append("[$size]; ");
            code.append("for ( int $idx = 0; $idx < $size; ++$idx ) { ");
            code.append(oref).append(decl.identifier);
            code.append("[$idx] = new ");
            code.append(decl.type);
            code.append("(xdr); ");
            code.append("} }\n");
        }
        return code.toString();
    }

    public static String checkForSpecials(String dataType) {
        if (globalIdentifiers.get(dataType) instanceof JrpcgenEnum) {
            return "int";
        }
        if ("opaque".equals(dataType)) {
            return "byte";
        }
        return dataType;
    }

    public static String boxForTransport(String javaType) {
        String xdrWrapper = jrpcgen.xdrBaseType(javaType);
        if (xdrWrapper != null) {
            return xdrWrapper;
        }
        return javaType;
    }

    public static String checkForEnumValue(String value) {
        if (value.length() > 0) {
            if (Character.isDigit(value.charAt(0)) || value.charAt(0) == '-') {
                return value;
            }
            Object id = globalIdentifiers.get(value);
            if (id != null && id instanceof JrpcgenConst) {
                JrpcgenConst c = (JrpcgenConst)id;
                if (c.enclosure == null) {
                    return c.value;
                }
                return c.enclosure + "." + c.identifier;
            }
        }
        return value;
    }

    public static void dumpStruct(JrpcgenStruct s) {
        JrpcgenDeclaration decl;
        JrpcgenDeclaration d;
        String access = "    public ";
        PrintWriter out = jrpcgen.createJavaSourceFile(s.identifier);
        out.print("public class " + s.identifier + " implements XdrAble");
        if (makeSerializable) {
            out.print(", java.io.Serializable");
        }
        if (makeBean) {
            access = "    protected ";
        }
        out.println(" {");
        boolean useIteration = false;
        JrpcgenSHA hash = jrpcgen.createSHA(s.identifier);
        Enumeration decls = s.elements.elements();
        while (decls.hasMoreElements()) {
            d = (JrpcgenDeclaration)decls.nextElement();
            hash.update(d.type);
            hash.update(d.kind);
            hash.update(d.identifier);
            out.print(access + jrpcgen.checkForSpecials(d.type) + " ");
            if (!(d.kind != 1 && d.kind != 2 || d.type.equals("String"))) {
                out.print("[] ");
            }
            if (initStrings && d.type.equals("String")) {
                out.println(d.identifier + " = \"\"; ");
            } else {
                out.println(d.identifier + ";");
            }
            if (decls.hasMoreElements() || d.kind != 3 || !d.type.equals(s.identifier)) continue;
            useIteration = true;
        }
        if (makeSerializable) {
            out.println();
            out.println("    private static final long serialVersionUID = " + hash.getHash() + "L;");
            if (makeBean) {
                decls = s.elements.elements();
                while (decls.hasMoreElements()) {
                    boolean isArray;
                    out.println();
                    d = (JrpcgenDeclaration)decls.nextElement();
                    String jbName = d.identifier.substring(0, 1).toUpperCase() + d.identifier.substring(1);
                    boolean bl = isArray = (d.kind == 1 || d.kind == 2) && !d.type.equals("String");
                    if (isArray) {
                        out.println("    public void set" + jbName + "(" + jrpcgen.checkForSpecials(d.type) + "[] x) { this." + d.identifier + " = x; }");
                        out.println("    public void set" + jbName + "(int index, " + jrpcgen.checkForSpecials(d.type) + " x) { this." + d.identifier + "[index] = x; }");
                    } else {
                        out.println("    public void set" + jbName + "(" + jrpcgen.checkForSpecials(d.type) + " x) { this." + d.identifier + " = x; }");
                    }
                    if (isArray) {
                        out.println("    public " + jrpcgen.checkForSpecials(d.type) + "[] get" + jbName + "() { return this." + d.identifier + "; }");
                        out.println("    public " + jrpcgen.checkForSpecials(d.type) + " get" + jbName + "(int index) { return this." + d.identifier + "[index]; }");
                        continue;
                    }
                    out.println("    public " + jrpcgen.checkForSpecials(d.type) + " get" + jbName + "() { return this." + d.identifier + "; }");
                }
            }
        }
        out.println();
        out.println("    public " + s.identifier + "() {");
        out.println("    }");
        out.println();
        out.println("    public " + s.identifier + "(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        xdrDecode(xdr);");
        out.println("    }");
        out.println();
        out.println("    public void xdrEncode(XdrEncodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        decls = s.elements.elements();
        if (useIteration) {
            out.println("        " + s.identifier + " $this = this;");
            out.println("        do {");
            decl = null;
            for (int size = s.elements.size(); size > 1; --size) {
                decl = (JrpcgenDeclaration)decls.nextElement();
                out.print("    " + jrpcgen.codingMethod(decl, true, "$this"));
            }
            decl = (JrpcgenDeclaration)decls.nextElement();
            out.println("            $this = $this." + decl.identifier + ";");
            out.println("            xdr.xdrEncodeBoolean($this != null);");
            out.println("        } while ( $this != null );");
        } else {
            while (decls.hasMoreElements()) {
                out.print(jrpcgen.codingMethod((JrpcgenDeclaration)decls.nextElement(), true));
            }
        }
        out.println("    }");
        out.println();
        out.println("    public void xdrDecode(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        decls = s.elements.elements();
        if (useIteration) {
            out.println("        " + s.identifier + " $this = this;");
            out.println("        " + s.identifier + " $next;");
            out.println("        do {");
            decl = null;
            for (int size = s.elements.size(); size > 1; --size) {
                decl = (JrpcgenDeclaration)decls.nextElement();
                out.print("    " + jrpcgen.codingMethod(decl, false, "$this"));
            }
            decl = (JrpcgenDeclaration)decls.nextElement();
            out.println("            $next = xdr.xdrDecodeBoolean() ? new " + s.identifier + "() : null;");
            out.println("            $this." + decl.identifier + " = $next;");
            out.println("            $this = $next;");
            out.println("        } while ( $this != null );");
        } else {
            while (decls.hasMoreElements()) {
                out.print(jrpcgen.codingMethod((JrpcgenDeclaration)decls.nextElement(), false));
            }
        }
        out.println("    }");
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpUnion(JrpcgenUnion u) {
        JrpcgenUnionArm a;
        JrpcgenUnionArm a2;
        PrintWriter out = jrpcgen.createJavaSourceFile(u.identifier);
        out.print("public class " + u.identifier + " implements XdrAble");
        if (makeSerializable) {
            out.print(", java.io.Serializable");
        }
        out.println(" {");
        out.println("    public " + jrpcgen.checkForSpecials(u.descriminant.type) + " " + u.descriminant.identifier + ";");
        boolean boolDescriminant = u.descriminant.type.equals("boolean");
        JrpcgenSHA hash = jrpcgen.createSHA(u.identifier);
        Enumeration arms = u.elements.elements();
        while (arms.hasMoreElements()) {
            a2 = (JrpcgenUnionArm)arms.nextElement();
            if (a2.element == null || a2.element.identifier == null) continue;
            if (a2.value != null) {
                hash.update(a2.value);
            } else {
                hash.update("default");
            }
            hash.update(a2.element.type);
            hash.update(a2.element.kind);
            hash.update(a2.element.identifier);
            out.print("    public " + jrpcgen.checkForSpecials(a2.element.type) + " ");
            if (!(a2.element.kind != 1 && a2.element.kind != 2 || a2.element.type.equals("String"))) {
                out.print("[] ");
            }
            out.println(a2.element.identifier + ";");
        }
        if (makeSerializable) {
            out.println();
            out.println("    private static final long serialVersionUID = " + hash.getHash() + "L;");
        }
        out.println();
        out.println("    public " + u.identifier + "() {");
        out.println("    }");
        out.println();
        out.println("    public " + u.identifier + "(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        xdrDecode(xdr);");
        out.println("    }");
        out.println();
        out.println("    public void xdrEncode(XdrEncodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(u.descriminant, true));
        if (!boolDescriminant) {
            out.println("        switch ( " + u.descriminant.identifier + " ) {");
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a2 = (JrpcgenUnionArm)arms.nextElement();
                if (a2.value != null) {
                    out.println("        case " + jrpcgen.checkForEnumValue(a2.value) + ":");
                } else {
                    out.println("        default:");
                }
                if (a2.element == null) continue;
                if (a2.element.identifier != null) {
                    out.print("    ");
                    out.print(jrpcgen.codingMethod(a2.element, true));
                }
                out.println("            break;");
            }
            out.println("        }");
        } else {
            boolean firstArm = true;
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value == null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                } else {
                    firstArm = false;
                }
                out.println("if ( " + u.descriminant.identifier + " == " + jrpcgen.checkForEnumValue(a.value) + " ) {");
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, true));
                out.println("        }");
            }
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value != null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                }
                out.println("{");
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, true));
                out.println("        }");
            }
        }
        out.println("    }");
        out.println();
        out.println("    public void xdrDecode(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(u.descriminant, false));
        if (!boolDescriminant) {
            out.println("        switch ( " + u.descriminant.identifier + " ) {");
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                JrpcgenUnionArm a3 = (JrpcgenUnionArm)arms.nextElement();
                if (a3.value != null) {
                    out.println("        case " + jrpcgen.checkForEnumValue(a3.value) + ":");
                } else {
                    out.println("        default:");
                }
                if (a3.element == null) continue;
                if (a3.element.identifier != null) {
                    out.print("    ");
                    out.print(jrpcgen.codingMethod(a3.element, false));
                }
                out.println("            break;");
            }
            out.println("        }");
        } else {
            boolean firstArm = true;
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value == null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                } else {
                    firstArm = false;
                }
                out.println("if ( " + u.descriminant.identifier + " == " + jrpcgen.checkForEnumValue(a.value) + " ) {");
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, false));
                out.println("        }");
            }
            arms = u.elements.elements();
            while (arms.hasMoreElements()) {
                a = (JrpcgenUnionArm)arms.nextElement();
                if (a.value != null || a.element.identifier == null) continue;
                out.print("        ");
                if (!firstArm) {
                    out.print("else ");
                }
                out.println("{");
                out.print("    ");
                out.print(jrpcgen.codingMethod(a.element, false));
                out.println("        }");
            }
        }
        out.println("    }");
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpTypedef(JrpcgenDeclaration d) {
        PrintWriter out = jrpcgen.createJavaSourceFile(d.identifier);
        out.print("public class " + d.identifier + " implements XdrAble");
        if (makeSerializable) {
            out.print(", java.io.Serializable");
        }
        out.println(" {");
        out.println();
        String paramType = jrpcgen.checkForSpecials(d.type);
        if (!(d.kind != 1 && d.kind != 2 || d.type.equals("String"))) {
            paramType = paramType + " []";
        }
        out.print("    public " + paramType + " value;");
        out.println();
        if (makeSerializable) {
            JrpcgenSHA hash = jrpcgen.createSHA(d.identifier);
            hash.update(d.type);
            hash.update(d.kind);
            out.println();
            out.println("    private static final long serialVersionUID = " + hash.getHash() + "L;");
        }
        JrpcgenDeclaration dstar = null;
        try {
            dstar = (JrpcgenDeclaration)d.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("fatal: can not clone JrpcgenDeclaration");
        }
        dstar.identifier = "value";
        out.println();
        out.println("    public " + d.identifier + "() {");
        out.println("    }");
        out.println();
        out.println("    public " + d.identifier + "(" + paramType + " value) {");
        out.println("        this.value = value;");
        out.println("    }");
        out.println();
        out.println("    public " + d.identifier + "(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        xdrDecode(xdr);");
        out.println("    }");
        out.println();
        out.println("    public void xdrEncode(XdrEncodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(dstar, true));
        out.println("    }");
        out.println();
        out.println("    public void xdrDecode(XdrDecodingStream xdr)");
        out.println("           throws OncRpcException, IOException {");
        out.print(jrpcgen.codingMethod(dstar, false));
        out.println("    }");
        out.println();
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpClasses() {
        for (Object o : globalIdentifiers.values()) {
            if (o instanceof JrpcgenEnum) {
                jrpcgen.dumpEnum((JrpcgenEnum)o);
                continue;
            }
            if (o instanceof JrpcgenStruct) {
                jrpcgen.dumpStruct((JrpcgenStruct)o);
                continue;
            }
            if (o instanceof JrpcgenUnion) {
                jrpcgen.dumpUnion((JrpcgenUnion)o);
                continue;
            }
            if (!(o instanceof JrpcgenDeclaration)) continue;
            jrpcgen.dumpTypedef((JrpcgenDeclaration)o);
        }
    }

    public static void dumpClientStubMethods(PrintWriter out, JrpcgenVersionInfo versionInfo) {
        int size = versionInfo.procedures.size();
        for (int idx = 0; idx < size; ++idx) {
            JrpcgenProcedureInfo proc = (JrpcgenProcedureInfo)versionInfo.procedures.elementAt(idx);
            if (generateSyncClient) {
                jrpcgen.dumpClientStubMethod(out, proc, ClientMethodType.SYNC);
            }
            if (generateAsyncFutureClient) {
                jrpcgen.dumpClientStubMethod(out, proc, ClientMethodType.FUTURE);
            }
            if (generateAsyncCallbackClient) {
                jrpcgen.dumpClientStubMethod(out, proc, ClientMethodType.CALLBACK);
            }
            if (!generateOneWayClient) continue;
            jrpcgen.dumpClientStubMethod(out, proc, ClientMethodType.ONE_WAY);
        }
    }

    private static void dumpClientStubMethod(PrintWriter out, JrpcgenProcedureInfo proc, ClientMethodType methodType) {
        int paramsKind;
        String methodName;
        String returnType;
        String resultType = jrpcgen.checkForSpecials(proc.resultType);
        boolean voidMethod = proc.resultType.compareTo("void") != 0;
        out.println("    /**");
        out.println("     * Call remote procedure " + proc.procedureId + ".");
        if (proc.parameters != null) {
            Enumeration params = proc.parameters.elements();
            while (params.hasMoreElements()) {
                JrpcgenParamInfo param = (JrpcgenParamInfo)params.nextElement();
                out.println("     * @param " + param.parameterName + " parameter (of type " + param.parameterType + ") to the remote procedure call.");
            }
        }
        if (generateTimeoutSupport && !ClientMethodType.ONE_WAY.equals((Object)methodType) && !ClientMethodType.FUTURE.equals((Object)methodType)) {
            out.println("     * @param _timeoutValue timeout value. 0 means no timeout.");
            out.println("     * @param _timeoutUnits units for _timeoutValue");
        }
        if (generatePerCallAuthSupport) {
            out.println("     * @param _auth authentication to use for call. null means constructor-provided default");
        }
        if (voidMethod) {
            out.println("     * @return Result from remote procedure call (of type " + proc.resultType + ").");
        }
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        if (generateTimeoutSupport && ClientMethodType.SYNC.equals((Object)methodType)) {
            out.println("     * @throws TimeoutException in case of timeout.");
        }
        out.println("     */");
        switch (methodType) {
            case SYNC: {
                returnType = resultType;
                methodName = proc.procedureId;
                break;
            }
            case FUTURE: {
                returnType = "Future<" + jrpcgen.boxForTransport(resultType) + ">";
                methodName = proc.procedureId + "_future";
                break;
            }
            case CALLBACK: {
                returnType = "void";
                methodName = proc.procedureId + "_callback";
                break;
            }
            case ONE_WAY: {
                returnType = "void";
                methodName = proc.procedureId + "_oneway";
                break;
            }
            default: {
                throw new IllegalStateException("unhandled: " + (Object)((Object)methodType));
            }
        }
        out.print("    public " + returnType + " " + methodName + "(");
        boolean anyParamsPrinted = false;
        if (proc.parameters != null) {
            String firstParamType;
            int psize = proc.parameters.size();
            for (int pidx = 0; pidx < psize; ++pidx) {
                JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                if (pidx > 0) {
                    out.print(", ");
                }
                out.print(jrpcgen.checkForSpecials(paramInfo.parameterType));
                out.print(" ");
                out.print(paramInfo.parameterName);
            }
            paramsKind = psize > 1 ? 3 : (jrpcgen.xdrBaseType(jrpcgen.checkForSpecials(firstParamType = ((JrpcgenParamInfo)proc.parameters.elementAt((int)0)).parameterType)) == null ? 1 : 2);
            anyParamsPrinted = true;
        } else {
            paramsKind = 0;
        }
        if (ClientMethodType.CALLBACK.equals((Object)methodType)) {
            if (anyParamsPrinted) {
                out.print(", ");
            }
            out.print("CompletionHandler<RpcReply, RpcTransport> completionHandler");
            anyParamsPrinted = true;
        }
        if (generateTimeoutSupport && !ClientMethodType.ONE_WAY.equals((Object)methodType) && !ClientMethodType.FUTURE.equals((Object)methodType)) {
            if (anyParamsPrinted) {
                out.print(", ");
            }
            out.print("long _timeoutValue, TimeUnit _timeoutUnit");
            anyParamsPrinted = true;
        }
        if (generatePerCallAuthSupport) {
            if (anyParamsPrinted) {
                out.print(", ");
            }
            out.print("RpcAuth _auth");
            anyParamsPrinted = true;
        }
        out.println(")");
        if (generateTimeoutSupport && ClientMethodType.SYNC.equals((Object)methodType)) {
            out.println("           throws OncRpcException, IOException, TimeoutException {");
        } else {
            out.println("           throws OncRpcException, IOException {");
        }
        String xdrParamsName = null;
        switch (paramsKind) {
            case 0: {
                xdrParamsName = "args$";
                out.println("        XdrVoid args$ = XdrVoid.XDR_VOID;");
                break;
            }
            case 1: {
                JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(0);
                xdrParamsName = paramInfo.parameterName;
                break;
            }
            case 2: {
                JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(0);
                xdrParamsName = "args$";
                String xdrParamsType = jrpcgen.xdrBaseType(jrpcgen.checkForSpecials(paramInfo.parameterType));
                out.println("        " + xdrParamsType + " args$ = new " + xdrParamsType + "(" + paramInfo.parameterName + ");");
                break;
            }
            case 3: {
                JrpcgenParamInfo pinfo;
                int pidx;
                xdrParamsName = "args$";
                out.println("        class XdrAble$ implements XdrAble {");
                int psize = proc.parameters.size();
                for (int pidx2 = 0; pidx2 < psize; ++pidx2) {
                    JrpcgenParamInfo pinfo2 = (JrpcgenParamInfo)proc.parameters.elementAt(pidx2);
                    out.println("            public " + jrpcgen.checkForSpecials(pinfo2.parameterType) + " " + pinfo2.parameterName + ";");
                }
                out.println("            public void xdrEncode(XdrEncodingStream xdr)");
                out.println("                throws OncRpcException, IOException {");
                JrpcgenDeclaration decl = new JrpcgenDeclaration(null, null);
                for (pidx = 0; pidx < psize; ++pidx) {
                    pinfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                    decl.kind = 0;
                    decl.identifier = pinfo.parameterName;
                    decl.type = pinfo.parameterType;
                    out.print("        ");
                    out.print(jrpcgen.codingMethod(decl, true));
                }
                out.println("            }");
                out.println("            public void xdrDecode(XdrDecodingStream xdr)");
                out.println("                throws OncRpcException, IOException {");
                out.println("            }");
                out.println("        };");
                out.println("        XdrAble$ args$ = new XdrAble$();");
                for (pidx = 0; pidx < psize; ++pidx) {
                    pinfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                    out.println("        args$." + pinfo.parameterName + " = " + pinfo.parameterName + ";");
                }
                break;
            }
        }
        String xdrResultType = jrpcgen.xdrBaseType(resultType);
        String timeoutArgsBit = generateTimeoutSupport ? ", _timeoutValue, _timeoutUnit" : "";
        String authArgBit = generatePerCallAuthSupport ? ", _auth" : "";
        switch (methodType) {
            case SYNC: {
                if (resultType.equals("void")) {
                    out.println("        XdrVoid result$ = XdrVoid.XDR_VOID;");
                } else if (xdrResultType != null) {
                    out.println("        " + xdrResultType + " result$ = new " + xdrResultType + "();");
                } else {
                    out.println("        " + resultType + " result$ = new " + resultType + "();");
                }
                out.println("        client.call(" + baseClassname + "." + proc.procedureId + ", " + xdrParamsName + ", result$" + timeoutArgsBit + authArgBit + ");");
                if (xdrResultType != null) {
                    if (resultType.equals("void")) break;
                    out.println("        return result$." + resultType.toLowerCase() + "Value();");
                    break;
                }
                out.println("        return result$;");
                break;
            }
            case FUTURE: {
                out.println("        return client.call(" + baseClassname + "." + proc.procedureId + ", " + xdrParamsName + ", " + jrpcgen.boxForTransport(resultType) + ".class" + authArgBit + ");");
                break;
            }
            case CALLBACK: {
                out.println("        client.call(" + baseClassname + "." + proc.procedureId + ", " + xdrParamsName + ", completionHandler" + timeoutArgsBit + authArgBit + ");");
                break;
            }
            case ONE_WAY: {
                out.println("        client.call(" + baseClassname + "." + proc.procedureId + ", " + xdrParamsName + ", (CompletionHandler) null" + authArgBit + ");");
                break;
            }
            default: {
                throw new IllegalStateException("unhandled: " + (Object)((Object)methodType));
            }
        }
        out.println("    }");
        out.println();
    }

    public static void dumpClient(JrpcgenProgramInfo programInfo) {
        int numVersions = programInfo.versions.size();
        JrpcgenVersionInfo maxVersionInfo = null;
        int maxVersion = Integer.MIN_VALUE;
        for (Object o : programInfo.versions) {
            JrpcgenVersionInfo versionInfo = (JrpcgenVersionInfo)o;
            int version = Integer.parseInt(versionInfo.versionNumber);
            if (maxVersionInfo != null && version <= maxVersion) continue;
            maxVersionInfo = versionInfo;
            maxVersion = version;
        }
        String clientClass = jrpcgen.clientClass;
        if (clientClass == null) {
            clientClass = baseClassname + "_" + programInfo.programId + "_Client";
            System.out.println("CLIENT: " + clientClass);
        }
        PrintWriter out = jrpcgen.createJavaSourceFile(clientClass);
        out.println("import java.io.Closeable;");
        out.println("import java.net.InetAddress;");
        if (generateAsyncFutureClient) {
            out.println("import java.util.concurrent.Future;");
        }
        if (generateAsyncCallbackClient || generateOneWayClient) {
            out.println("import java.nio.channels.CompletionHandler;");
        }
        if (generateTimeoutSupport) {
            out.println("import java.util.concurrent.TimeUnit;");
            out.println("import java.util.concurrent.TimeoutException;");
        }
        out.println();
        out.println("/**");
        out.println(" * The class <code>" + clientClass + "</code> implements the client stub proxy");
        out.println(" * for the " + programInfo.programId + " remote program. It provides method stubs");
        out.println(" * which, when called, in turn call the appropriate remote method (procedure).");
        out.println(" */");
        out.println("public class " + clientClass + " implements Closeable {");
        out.println();
        out.println("    private static final String DEFAULT_SERVICE_NAME = null;");
        out.println("    private final OncRpcClient rpcClient;");
        out.println("    private final RpcCall client;");
        out.println();
        out.println("    /**");
        out.println("     * see {@link #" + clientClass + "(InetAddress, int, RpcAuth, int, int, int , int, IoStrategy, String)}");
        out.println("     */");
        out.println("    public " + clientClass + "(InetAddress host, int port)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        this(host, port, new RpcAuthTypeNone(), " + baseClassname + "." + programInfo.programId + ", " + baseClassname + "." + maxVersionInfo.versionId + ", IpProtocolType.TCP, 0, IoStrategy.SAME_THREAD, DEFAULT_SERVICE_NAME);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println("     * see {@link #" + clientClass + "(InetAddress, int, RpcAuth, int, int, int , int, IoStrategy, String)}");
        out.println("     */");
        out.println("    public " + clientClass + "(InetAddress host, int port, int version)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        this(host, port, new RpcAuthTypeNone(), " + baseClassname + "." + programInfo.programId + ", version, IpProtocolType.TCP, 0, IoStrategy.SAME_THREAD, DEFAULT_SERVICE_NAME);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println("     * see {@link #" + clientClass + "(InetAddress, int, RpcAuth, int, int, int , int, IoStrategy, String)}");
        out.println("     */");
        out.println("    public " + clientClass + "(InetAddress host, int port, int program, int version, int protocol)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        this(host, port, new RpcAuthTypeNone(), program, version, protocol, 0, IoStrategy.SAME_THREAD, DEFAULT_SERVICE_NAME);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println("     * see {@link #" + clientClass + "(InetAddress, int, RpcAuth, int, int, int , int, IoStrategy, String)}");
        out.println("     */");
        out.println("    public " + clientClass + "(InetAddress host, int port, RpcAuth auth, int program, int version, int protocol)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        this(host, port, auth, program, version, protocol, 0, IoStrategy.SAME_THREAD, DEFAULT_SERVICE_NAME);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println("     * see {@link #" + clientClass + "(InetAddress, int, RpcAuth, int, int, int , int, IoStrategy, String)}");
        out.println("     */");
        out.println("    public " + clientClass + "(InetAddress host, int port, RpcAuth auth, int program, int version, int protocol, int localPort)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        this(host, port, auth, program, version, protocol, localPort, IoStrategy.SAME_THREAD, DEFAULT_SERVICE_NAME);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println("     * see {@link #" + clientClass + "(InetAddress, int, RpcAuth, int, int, int , int, IoStrategy, String)}");
        out.println("     */");
        out.println("    public " + clientClass + "(InetAddress host, int port, RpcAuth auth, int program, int version, int protocol, int localPort, IoStrategy ioStrategy)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        this(host, port, auth, program, version, protocol, localPort, ioStrategy, DEFAULT_SERVICE_NAME);");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println("     * Constructs a <code>" + clientClass + "</code> client stub proxy object");
        out.println("     * from which the " + programInfo.programId + " remote program can be accessed.");
        out.println("     * @param host Internet address of host where to contact the remote program.");
        out.println("     * @param port Port number at host where the remote program can be reached.");
        out.println("     * @param auth {@link RpcAuth} to be used for RPC client authentication.");
        out.println("     * @param program Remote program number.");
        out.println("     * @param version Remote program version number.");
        out.println("     * @param protocol {@link org.dcache.oncrpc4j.rpc.net.IpProtocolType} to be");
        out.println("     *   used for ONC/RPC calls.");
        out.println("     * @param localPort local port to bind to. <=0 for any (ephemeral)");
        out.println("     * @param ioStrategy io handling strategy. null for default");
        out.println("     * @param serviceName to identify threads created for the service. null for default");
        out.println("     * @throws OncRpcException if an ONC/RPC error occurs.");
        out.println("     * @throws IOException if an I/O error occurs.");
        out.println("     */");
        out.println("    public " + clientClass + "(InetAddress host, int port, RpcAuth auth, int program, int version, int protocol, int localPort, IoStrategy ioStrategy, String serviceName)");
        out.println("           throws OncRpcException, IOException {");
        out.println("        rpcClient = new OncRpcClient(host, protocol, port, localPort, ioStrategy, serviceName);");
        out.println("        try {");
        out.println("            client = new RpcCall(program, version, auth, rpcClient.connect());");
        out.println("        } catch (IOException e) {");
        out.println("            rpcClient.close();");
        out.println("            throw e;");
        out.println("        } ");
        out.println("    }");
        out.println();
        out.println("   /**");
        out.println("     * Shutdown client connection.");
        out.println("     *");
        out.println("     * @throws IOException");
        out.println("     */");
        out.println("    public void shutdown() throws IOException {");
        out.println("        rpcClient.close();");
        out.println("    }");
        out.println();
        out.println("    @Override");
        out.println("    public void close() throws IOException {");
        out.println("        shutdown();");
        out.println("    }");
        out.println();
        for (int versionIdx = 0; versionIdx < numVersions; ++versionIdx) {
            JrpcgenVersionInfo versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            jrpcgen.dumpClientStubMethods(out, versionInfo);
        }
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpServerStubMethodCall(PrintWriter out, JrpcgenProcedureInfo proc) {
        String firstParamType;
        int psize;
        String resultType = jrpcgen.checkForSpecials(proc.resultType);
        int paramsKind = proc.parameters != null ? ((psize = proc.parameters.size()) > 1 ? 3 : (jrpcgen.xdrBaseType(jrpcgen.checkForSpecials(firstParamType = ((JrpcgenParamInfo)proc.parameters.elementAt((int)0)).parameterType)) == null ? 1 : 2)) : 0;
        String params = "";
        switch (paramsKind) {
            case 0: {
                out.println("                call.retrieveCall(XdrVoid.XDR_VOID);");
                params = "call";
                break;
            }
            case 1: {
                JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(0);
                out.println("                " + paramInfo.parameterType + " args$ = new " + paramInfo.parameterType + "();");
                out.println("                call.retrieveCall(args$);");
                params = "call, args$";
                break;
            }
            case 2: {
                JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(0);
                String paramsType = jrpcgen.checkForSpecials(paramInfo.parameterType);
                String xdrParamsType = jrpcgen.xdrBaseType(paramsType);
                out.println("                " + xdrParamsType + " args$ = new " + xdrParamsType + "();");
                out.println("                call.retrieveCall(args$);");
                params = "call, args$." + paramsType.toLowerCase() + "Value()";
                break;
            }
            case 3: {
                JrpcgenParamInfo pinfo;
                int pidx;
                StringBuilder paramsBuff = new StringBuilder();
                out.println("                class XdrAble$ implements XdrAble {");
                int psize2 = proc.parameters.size();
                for (int pidx2 = 0; pidx2 < psize2; ++pidx2) {
                    JrpcgenParamInfo pinfo2 = (JrpcgenParamInfo)proc.parameters.elementAt(pidx2);
                    out.println("                    public " + jrpcgen.checkForSpecials(pinfo2.parameterType) + " " + pinfo2.parameterName + ";");
                }
                out.println("                    public void xdrEncode(XdrEncodingStream xdr)");
                out.println("                        throws OncRpcException, IOException {");
                out.println("                    }");
                out.println("                    public void xdrDecode(XdrDecodingStream xdr)");
                out.println("                        throws OncRpcException, IOException {");
                JrpcgenDeclaration decl = new JrpcgenDeclaration(null, null);
                for (pidx = 0; pidx < psize2; ++pidx) {
                    pinfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                    decl.kind = 0;
                    decl.identifier = pinfo.parameterName;
                    decl.type = pinfo.parameterType;
                    out.print("                ");
                    out.print(jrpcgen.codingMethod(decl, false));
                }
                out.println("                    }");
                out.println("                };");
                out.println("                XdrAble$ args$ = new XdrAble$();");
                out.println("                call.retrieveCall(args$);");
                if (psize2 > 0) {
                    paramsBuff.append("call, ");
                } else {
                    paramsBuff.append("call");
                }
                for (pidx = 0; pidx < psize2; ++pidx) {
                    pinfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                    if (pidx > 0) {
                        paramsBuff.append(", ");
                    }
                    paramsBuff.append("args$.");
                    paramsBuff.append(pinfo.parameterName);
                }
                params = paramsBuff.toString();
                break;
            }
        }
        String xdrResultType = jrpcgen.xdrBaseType(resultType);
        if (resultType.equals("void")) {
            out.println("                " + proc.procedureId + "(" + params + ");");
            out.println("                call.reply(XdrVoid.XDR_VOID);");
        } else if (xdrResultType != null) {
            out.println("                " + xdrResultType + " result$ = new " + xdrResultType + "(" + proc.procedureId + "(" + params + "));");
            out.println("                call.reply(result$);");
        } else {
            out.println("                " + resultType + " result$ = " + proc.procedureId + "(" + params + ");");
            out.println("                call.reply(result$);");
        }
    }

    public static void dumpServerStubMethods(PrintWriter out, JrpcgenVersionInfo versionInfo) {
        int procSize = versionInfo.procedures.size();
        for (int idx = 0; idx < procSize; ++idx) {
            JrpcgenProcedureInfo proc = (JrpcgenProcedureInfo)versionInfo.procedures.elementAt(idx);
            String resultType = jrpcgen.checkForSpecials(proc.resultType);
            out.print("    public abstract " + resultType + " " + proc.procedureId + "(");
            if (proc.parameters != null) {
                out.print("RpcCall call$, ");
                int psize = proc.parameters.size();
                for (int pidx = 0; pidx < psize; ++pidx) {
                    JrpcgenParamInfo paramInfo = (JrpcgenParamInfo)proc.parameters.elementAt(pidx);
                    if (pidx > 0) {
                        out.print(", ");
                    }
                    out.print(jrpcgen.checkForSpecials(paramInfo.parameterType));
                    out.print(" ");
                    out.print(paramInfo.parameterName);
                }
            } else {
                out.print("RpcCall call$");
            }
            out.println(");");
            out.println();
        }
    }

    public static void dumpServer(JrpcgenProgramInfo programInfo) {
        JrpcgenVersionInfo versionInfo;
        int versionIdx;
        String serverClass = jrpcgen.serverClass;
        if (serverClass == null) {
            serverClass = baseClassname + "_" + programInfo.programId + "_ServerStub";
        }
        PrintWriter out = jrpcgen.createJavaSourceFile(serverClass);
        out.println("import org.dcache.oncrpc4j.xdr.*;");
        out.println();
        out.println("/**");
        out.println(" */");
        out.println("public abstract class " + serverClass + " implements RpcDispatchable {");
        out.println();
        int versionSize = programInfo.versions.size();
        out.println("    public void dispatchOncRpcCall(RpcCall call)");
        out.println("           throws OncRpcException, IOException {");
        out.println();
        out.println("        int version = call.getProgramVersion();");
        out.println("        int procedure = call.getProcedure();");
        out.println();
        for (versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            out.print(versionIdx == 0 ? "        " : "        } else ");
            out.println("if ( version == " + versionInfo.versionNumber + " ) {");
            int procSize = versionInfo.procedures.size();
            out.println("            switch ( procedure ) {");
            for (int procIdx = 0; procIdx < procSize; ++procIdx) {
                JrpcgenProcedureInfo procInfo = (JrpcgenProcedureInfo)versionInfo.procedures.elementAt(procIdx);
                out.println("            case " + jrpcgen.checkForEnumValue(procInfo.procedureNumber) + ": {");
                jrpcgen.dumpServerStubMethodCall(out, procInfo);
                out.println("                break;");
                out.println("            }");
            }
            out.println("            default:");
            out.println("                call.failProcedureUnavailable();");
            out.println("            }");
        }
        out.println("        } else {");
        out.println("            call.failProgramUnavailable();");
        out.println("        }");
        out.println("    }");
        out.println();
        for (versionIdx = 0; versionIdx < versionSize; ++versionIdx) {
            versionInfo = (JrpcgenVersionInfo)programInfo.versions.elementAt(versionIdx);
            jrpcgen.dumpServerStubMethods(out, versionInfo);
        }
        out.println("}");
        jrpcgen.closeJavaSourceFile();
    }

    public static void dumpFiles() {
        jrpcgen.dumpConstants();
        jrpcgen.dumpClasses();
        for (JrpcgenProgramInfo progInfo : programInfos) {
            if (!noClient) {
                jrpcgen.dumpClient(progInfo);
            }
            if (noServer) continue;
            jrpcgen.dumpServer(progInfo);
        }
    }

    public static void main(String[] args) {
        String arg;
        int argIdx;
        int argc = args.length;
        for (argIdx = 0; argIdx < argc && ((arg = args[argIdx]).length() <= 0 || arg.charAt(0) == '-'); ++argIdx) {
            if (arg.equals("-d")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing directory");
                    System.exit(1);
                }
                destinationDir = new File(args[argIdx]);
                continue;
            }
            if (arg.equals("-package") || arg.equals("-p")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing package name");
                    System.exit(1);
                }
                packageName = args[argIdx];
                continue;
            }
            if (arg.equals("-c")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing client class name");
                    System.exit(1);
                }
                clientClass = args[argIdx];
                continue;
            }
            if (arg.equals("-s")) {
                if (++argIdx >= argc) {
                    System.out.println("jrpcgen: missing server class name");
                    System.exit(1);
                }
                serverClass = args[argIdx];
                continue;
            }
            if (arg.equals("-ser")) {
                makeSerializable = true;
                continue;
            }
            if (arg.equals("-bean")) {
                makeSerializable = true;
                makeBean = true;
                continue;
            }
            if (arg.equals("-initstrings")) {
                initStrings = true;
                continue;
            }
            if (arg.equals("-debug")) {
                debug = true;
                continue;
            }
            if (arg.equals("-nobackup")) {
                noBackups = true;
                continue;
            }
            if (arg.equals("-noclient")) {
                noClient = true;
                continue;
            }
            if (arg.equals("-noserver")) {
                noServer = true;
                continue;
            }
            if (arg.equals("-parseonly")) {
                parseOnly = true;
                continue;
            }
            if (arg.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-asyncfuture")) {
                generateAsyncFutureClient = true;
                continue;
            }
            if (arg.equals("-asynccallback")) {
                generateAsyncCallbackClient = true;
                continue;
            }
            if (arg.equals("-oneway")) {
                generateOneWayClient = true;
                continue;
            }
            if (arg.equals("-nosync")) {
                generateSyncClient = false;
                continue;
            }
            if (arg.equals("-timeouts")) {
                generateTimeoutSupport = true;
                continue;
            }
            if (arg.equals("-percallauth")) {
                generatePerCallAuthSupport = true;
                continue;
            }
            if (arg.equals("-version")) {
                System.out.println("jrpcgen version \"1.0.7+\"");
                System.exit(1);
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                jrpcgen.printHelp();
                System.exit(1);
                continue;
            }
            if (arg.equals("--")) {
                ++argIdx;
                break;
            }
            System.out.println("Unrecognized option: " + arg);
            System.exit(1);
        }
        if (!(packageName == null || packageName.isEmpty() || (destinationDir = new File(destinationDir, packageName.replaceAll("\\.", Matcher.quoteReplacement(File.separator)))).exists() || destinationDir.mkdirs())) {
            throw new IllegalStateException("unable to create path " + destinationDir);
        }
        if (argIdx >= argc || argIdx < argc - 1) {
            jrpcgen.printHelp();
            System.exit(1);
        }
        String xfilename = args[argIdx];
        xFile = new File(xfilename);
        try {
            jrpcgen.doParse();
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            System.exit(1);
        }
    }

    public static void doParse() throws FileNotFoundException, Exception {
        if (baseClassname == null) {
            String name = xFile.getName();
            int dotIdx = name.lastIndexOf(46);
            baseClassname = dotIdx < 0 ? name : name.substring(0, dotIdx);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(xFile.getCanonicalPath());
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("jrpcgen: can not open source x-file \"" + xFile.getCanonicalPath() + "\"");
        }
        JrpcgenScanner scanner = new JrpcgenScanner(in);
        JrpcgenParser parser = new JrpcgenParser(scanner);
        globalIdentifiers.put("TRUE", new JrpcgenConst("TRUE", "true"));
        globalIdentifiers.put("FALSE", new JrpcgenConst("FALSE", "false"));
        try {
            Symbol sym = parser.parse();
            if (!parseOnly) {
                if (programInfos.size() <= 1) {
                    if (clientClass == null) {
                        clientClass = baseClassname + "Client";
                    }
                    if (serverClass == null) {
                        serverClass = baseClassname + "ServerStub";
                    }
                }
                jrpcgen.dumpFiles();
            }
        }
        catch (JrpcgenParserException pe) {
            throw new Exception("jrpcgen: compilation aborted (" + pe.getMessage() + ")");
        }
    }

    private static enum ClientMethodType {
        SYNC,
        FUTURE,
        CALLBACK,
        ONE_WAY;

    }
}

