/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.xdr.ClientTransport;
import org.dcache.xdr.GrizzlyUtils;
import org.dcache.xdr.IoStrategy;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.RpcProtocolFilter;
import org.dcache.xdr.XdrTransport;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.NIOTransportBuilder;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncRpcClient
implements AutoCloseable {
    private static final Logger _log = LoggerFactory.getLogger(OncRpcClient.class);
    private final InetSocketAddress _socketAddress;
    private final int _localPort;
    private final Transport _transport;
    private final ReplyQueue _replyQueue = new ReplyQueue();

    public OncRpcClient(InetAddress address, int protocol, int port) {
        this(new InetSocketAddress(address, port), protocol, -1, null);
    }

    public OncRpcClient(InetAddress address, int protocol, int port, int localPort) {
        this(new InetSocketAddress(address, port), protocol, localPort, null);
    }

    public OncRpcClient(InetAddress address, int protocol, int port, int localPort, IoStrategy ioStrategy) {
        this(new InetSocketAddress(address, port), protocol, localPort, ioStrategy);
    }

    public OncRpcClient(InetSocketAddress socketAddress, int protocol) {
        this(socketAddress, protocol, -1, null);
    }

    public OncRpcClient(InetSocketAddress socketAddress, int protocol, int localPort, IoStrategy ioStrategy) {
        NIOTransportBuilder transportBuilder;
        this._socketAddress = socketAddress;
        this._localPort = localPort;
        if (protocol == 6) {
            transportBuilder = TCPNIOTransportBuilder.newInstance();
        } else if (protocol == 17) {
            transportBuilder = UDPNIOTransportBuilder.newInstance();
        } else {
            throw new IllegalArgumentException("Unsupported protocol type: " + protocol);
        }
        if (ioStrategy != null) {
            transportBuilder.setIOStrategy(GrizzlyUtils.translate(ioStrategy));
        }
        this._transport = transportBuilder.build();
        FilterChainBuilder filterChain = FilterChainBuilder.stateless();
        filterChain.add(new TransportFilter());
        filterChain.add(GrizzlyUtils.rpcMessageReceiverFor(this._transport));
        filterChain.add(new RpcProtocolFilter(this._replyQueue));
        this._transport.setProcessor(filterChain.build());
        this._transport.setIOStrategy(SameThreadIOStrategy.getInstance());
        this._transport.getConnectionMonitoringConfig().addProbes((ConnectionProbe[])new ConnectionProbe[]{new ConnectionProbe.Adapter(){

            @Override
            public void onCloseEvent(Connection connection) {
                OncRpcClient.this._replyQueue.handleDisconnect();
            }
        }});
    }

    public XdrTransport connect() throws IOException {
        return this.connect(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public XdrTransport connect(long timeout, TimeUnit timeUnit) throws IOException {
        Connection _connection;
        Future<Connection> connectFuture;
        this._transport.start();
        SocketConnectorHandler asConnectionHandler = (SocketConnectorHandler)((Object)this._transport);
        if (this._localPort > 0) {
            InetSocketAddress localAddress = new InetSocketAddress(this._localPort);
            connectFuture = asConnectionHandler.connect(this._socketAddress, localAddress);
        } else {
            connectFuture = asConnectionHandler.connect(this._socketAddress);
        }
        try {
            _connection = connectFuture.get(timeout, timeUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException(e.toString(), e);
        }
        return new ClientTransport(_connection, this._replyQueue);
    }

    @Override
    public void close() throws IOException {
        this._transport.shutdown();
    }
}

