/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.utils.net.InetSocketAddresses;
import org.dcache.xdr.GrizzlyUtils;
import org.dcache.xdr.IoStrategy;
import org.dcache.xdr.OncRpcClient;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.OncRpcSvcBuilder;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.RpcDispatchable;
import org.dcache.xdr.RpcDispatcher;
import org.dcache.xdr.RpcProgUnavailable;
import org.dcache.xdr.RpcProtocolFilter;
import org.dcache.xdr.XdrTransport;
import org.dcache.xdr.gss.GssProtocolFilter;
import org.dcache.xdr.gss.GssSessionManager;
import org.dcache.xdr.portmap.GenericPortmapClient;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.SocketBinder;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.jmxbase.GrizzlyJmxManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncRpcSvc {
    private static final Logger _log = LoggerFactory.getLogger(OncRpcSvc.class);
    private final int _backlog;
    private final boolean _publish;
    private final PortRange _portRange;
    private final String _bindAddress;
    private final List<Transport> _transports = new ArrayList<Transport>();
    private final Set<Connection<InetSocketAddress>> _boundConnections = new HashSet<Connection<InetSocketAddress>>();
    private final ExecutorService _requestExecutor;
    private final ReplyQueue _replyQueue = new ReplyQueue();
    private final GssSessionManager _gssSessionManager;
    private final Map<OncRpcProgram, RpcDispatchable> _programs = new ConcurrentHashMap<OncRpcProgram, RpcDispatchable>();

    OncRpcSvc(OncRpcSvcBuilder builder) {
        this._publish = builder.isAutoPublish();
        int protocol = builder.getProtocol();
        if ((protocol & 0x17) == 0) {
            throw new IllegalArgumentException("TCP or UDP protocol have to be defined");
        }
        IoStrategy ioStrategy = builder.getIoStrategy();
        String serviceName = builder.getServiceName();
        ThreadPoolConfig selectorPoolConfig = GrizzlyUtils.getSelectorPoolCfg(ioStrategy, serviceName);
        if ((protocol & 6) != 0) {
            TCPNIOTransport tcpTransport = ((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setReuseAddress(true)).setIOStrategy(SameThreadIOStrategy.getInstance())).setSelectorThreadPoolConfig(selectorPoolConfig)).build();
            this._transports.add(tcpTransport);
        }
        if ((protocol & 0x11) != 0) {
            UDPNIOTransport udpTransport = ((UDPNIOTransportBuilder)((UDPNIOTransportBuilder)((UDPNIOTransportBuilder)UDPNIOTransportBuilder.newInstance().setReuseAddress(true)).setIOStrategy(SameThreadIOStrategy.getInstance())).setSelectorThreadPoolConfig(selectorPoolConfig)).build();
            this._transports.add(udpTransport);
        }
        this._portRange = new PortRange(builder.getMinPort(), builder.getMaxPort());
        this._backlog = builder.getBacklog();
        this._bindAddress = builder.getBindAddress();
        if (builder.isWithJMX()) {
            GrizzlyJmxManager jmxManager = GrizzlyJmxManager.instance();
            for (Transport t : this._transports) {
                jmxManager.registerAtRoot(t.getMonitoringConfig().createManagementObject(), t.getName() + "-" + this._portRange);
            }
        }
        this._requestExecutor = builder.getWorkerThreadExecutorService();
        this._gssSessionManager = builder.getGssSessionManager();
    }

    public void register(OncRpcProgram prog, RpcDispatchable handler) {
        _log.info("Registering new program {} : {}", (Object)prog, (Object)handler);
        this._programs.put(prog, handler);
    }

    public void unregister(OncRpcProgram prog) {
        _log.info("Unregistering program {}", (Object)prog);
        this._programs.remove(prog);
    }

    public void setPrograms(Map<OncRpcProgram, RpcDispatchable> services) {
        this._programs.putAll(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishToPortmap(Connection<InetSocketAddress> connection, Set<OncRpcProgram> programs) throws IOException {
        OncRpcClient rpcClient = new OncRpcClient(InetAddress.getByName(null), 17, 111);
        XdrTransport transport = rpcClient.connect();
        try {
            String netidBase;
            GenericPortmapClient portmapClient = new GenericPortmapClient(transport);
            HashSet<String> netids = new HashSet<String>();
            String username = System.getProperty("user.name");
            Transport t = connection.getTransport();
            String uaddr = InetSocketAddresses.uaddrOf(connection.getLocalAddress());
            if (t instanceof TCPNIOTransport) {
                netidBase = "tcp";
            } else if (t instanceof UDPNIOTransport) {
                netidBase = "udp";
            } else {
                throw new RuntimeException("Unsupported transport type: " + t.getClass().getCanonicalName());
            }
            InetAddress localAddress = connection.getLocalAddress().getAddress();
            if (localAddress instanceof Inet6Address) {
                netids.add(netidBase + "6");
                if (((Inet6Address)localAddress).isIPv4CompatibleAddress()) {
                    netids.add(netidBase);
                }
            } else {
                netids.add(netidBase);
            }
            for (OncRpcProgram program : programs) {
                for (String netid2 : netids) {
                    try {
                        portmapClient.setPort(program.getNumber(), program.getVersion(), netid2, uaddr, username);
                    }
                    catch (TimeoutException | OncRpcException e) {
                        _log.warn("Failed to register program: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        catch (RpcProgUnavailable e) {
            _log.warn("Failed to register at portmap: {}", (Object)e.getMessage());
        }
        finally {
            rpcClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPortmap(Set<OncRpcProgram> programs) throws IOException {
        OncRpcClient rpcClient = new OncRpcClient(InetAddress.getByName(null), 17, 111);
        XdrTransport transport = rpcClient.connect();
        try {
            GenericPortmapClient portmapClient = new GenericPortmapClient(transport);
            String username = System.getProperty("user.name");
            for (OncRpcProgram program : programs) {
                try {
                    portmapClient.unsetPort(program.getNumber(), program.getVersion(), username);
                }
                catch (TimeoutException | OncRpcException e) {
                    _log.info("Failed to unregister program: {}", (Object)e.getMessage());
                }
            }
        }
        catch (RpcProgUnavailable e) {
            _log.info("portmap service not available");
        }
        finally {
            rpcClient.close();
        }
    }

    public void start() throws IOException {
        if (this._publish) {
            this.clearPortmap(this._programs.keySet());
        }
        for (Transport t : this._transports) {
            FilterChainBuilder filterChain = FilterChainBuilder.stateless();
            filterChain.add(new TransportFilter());
            filterChain.add(GrizzlyUtils.rpcMessageReceiverFor(t));
            filterChain.add(new RpcProtocolFilter(this._replyQueue));
            if (this._gssSessionManager != null) {
                filterChain.add(new GssProtocolFilter(this._gssSessionManager));
            }
            filterChain.add(new RpcDispatcher(this._requestExecutor, this._programs));
            FilterChain filters = filterChain.build();
            t.setProcessor(filters);
            Connection connection = ((SocketBinder)((Object)t)).bind(this._bindAddress, this._portRange, this._backlog);
            t.start();
            this._boundConnections.add(connection);
            if (!this._publish) continue;
            this.publishToPortmap(connection, this._programs.keySet());
        }
    }

    public void stop() throws IOException {
        if (this._publish) {
            this.clearPortmap(this._programs.keySet());
        }
        for (Transport t : this._transports) {
            t.shutdownNow();
        }
        this._requestExecutor.shutdown();
    }

    public void stop(long gracePeriod, TimeUnit timeUnit) throws IOException {
        if (this._publish) {
            this.clearPortmap(this._programs.keySet());
        }
        ArrayList<GrizzlyFuture<Transport>> transportsShuttingDown = new ArrayList<GrizzlyFuture<Transport>>();
        for (Transport transport : this._transports) {
            transportsShuttingDown.add(transport.shutdown(gracePeriod, timeUnit));
        }
        for (GrizzlyFuture grizzlyFuture : transportsShuttingDown) {
            try {
                grizzlyFuture.get();
            }
            catch (Exception e) {
                _log.warn("Exception while waiting for transport to shut down gracefully", e);
            }
        }
        this._requestExecutor.shutdown();
    }

    public InetSocketAddress getInetSocketAddress(int protocol) {
        Class<? extends Transport> transportClass = GrizzlyUtils.transportFor(protocol);
        for (Connection<InetSocketAddress> connection : this._boundConnections) {
            if (connection.getTransport().getClass() != transportClass) continue;
            return connection.getLocalAddress();
        }
        return null;
    }
}

