/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr.gss;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.UUID;
import org.dcache.utils.Bytes;
import org.dcache.xdr.BadXdrOncRpcException;
import org.dcache.xdr.RpcAuthError;
import org.dcache.xdr.RpcAuthVerifier;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.RpcException;
import org.dcache.xdr.gss.GSSINITargs;
import org.dcache.xdr.gss.GSSINITres;
import org.dcache.xdr.gss.GssSessionManager;
import org.dcache.xdr.gss.RpcAuthGss;
import org.dcache.xdr.gss.RpcGssCall;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GssProtocolFilter
extends BaseFilter {
    private static final Logger _log = LoggerFactory.getLogger(GssProtocolFilter.class);
    public static final int COMPLETE = 0;
    public static final int CONTINUE_NEEDED = 1;
    private final GssSessionManager _gssSessionManager;

    public GssProtocolFilter(GssSessionManager gssSessionManager) {
        this._gssSessionManager = gssSessionManager;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        RpcCall call = (RpcCall)ctx.getMessage();
        if (call.getCredential().type() != 6) {
            return ctx.getInvokeAction();
        }
        boolean hasContext = false;
        try {
            RpcAuthGss authGss = (RpcAuthGss)call.getCredential();
            GSSContext gssContext = null;
            int _sequence = authGss.getSequence();
            switch (authGss.getProc()) {
                case 1: {
                    UUID uuid = UUID.randomUUID();
                    byte[] handle = new byte[16];
                    Bytes.putLong(handle, 0, uuid.getLeastSignificantBits());
                    Bytes.putLong(handle, 8, uuid.getMostSignificantBits());
                    gssContext = this._gssSessionManager.createContext(handle);
                    authGss.setHandle(handle);
                }
                case 2: {
                    if (gssContext == null) {
                        gssContext = this._gssSessionManager.getContext(authGss.getHandle());
                    }
                    GSSINITargs gssArgs = new GSSINITargs();
                    GSSINITres res = new GSSINITres();
                    call.retrieveCall(gssArgs);
                    byte[] inToken = gssArgs.getToken();
                    byte[] outToken = gssContext.acceptSecContext(inToken, 0, inToken.length);
                    res.setHandle(authGss.getHandle());
                    res.setGssMajor(gssContext.isEstablished() ? 0 : 1);
                    res.setGssMinor(0);
                    res.setToken(outToken);
                    if (gssContext.isEstablished()) {
                        _sequence = 128;
                        res.setSequence(_sequence);
                        byte[] crc = Ints.toByteArray(_sequence);
                        crc = gssContext.getMIC(crc, 0, 4, new MessageProp(false));
                        authGss.setVerifier(new RpcAuthVerifier(authGss.type(), crc));
                    }
                    call.reply(res);
                    break;
                }
                case 3: {
                    gssContext = this._gssSessionManager.destroyContext(authGss.getHandle());
                    this.validateVerifier(authGss, gssContext);
                    gssContext.dispose();
                    break;
                }
                case 0: {
                    gssContext = this._gssSessionManager.getEstablishedContext(authGss.getHandle());
                    this.validateVerifier(authGss, gssContext);
                    GSSName sourceName = gssContext.getSrcName();
                    authGss.getSubject().getPrincipals().addAll(this._gssSessionManager.subjectOf(sourceName).getPrincipals());
                    _log.debug("RPCGSS_SEC: {}", (Object)sourceName);
                    byte[] crc = Ints.toByteArray(authGss.getSequence());
                    crc = gssContext.getMIC(crc, 0, 4, new MessageProp(false));
                    authGss.setVerifier(new RpcAuthVerifier(authGss.type(), crc));
                    ctx.setMessage(new RpcGssCall(call, gssContext, new MessageProp(false)));
                    hasContext = true;
                }
            }
        }
        catch (RpcException e) {
            call.reject(e.getStatus(), e.getRpcReply());
            _log.warn("GSS mechanism failed {}", (Object)e.getMessage());
        }
        catch (BadXdrOncRpcException e) {
            call.failRpcGarbage();
            _log.warn("Broken RPCSEC_GSS package: {}", (Object)e.getMessage());
        }
        catch (IOException | GSSException e) {
            call.reject(1, new RpcAuthError(14));
            _log.warn("GSS mechanism failed {}", (Object)e.getMessage());
        }
        if (hasContext) {
            return ctx.getInvokeAction();
        }
        return ctx.getStopAction();
    }

    private void validateVerifier(RpcAuthGss auth, GSSContext context) throws GSSException {
        Buffer header = auth.getHeader();
        byte[] bb = new byte[header.remaining()];
        header.get(bb);
        context.verifyMIC(auth.getVerifier().getBody(), 0, auth.getVerifier().getBody().length, bb, 0, bb.length, new MessageProp(false));
    }
}

