/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import org.dcache.xdr.IoStrategy;
import org.dcache.xdr.RpcMessageParserTCP;
import org.dcache.xdr.RpcMessageParserUDP;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.strategies.LeaderFollowerNIOStrategy;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class GrizzlyUtils {
    private static final int MIN_SELECTORS = 2;
    private static final int MIN_WORKERS = 5;
    static final int CPUS = Runtime.getRuntime().availableProcessors();

    private GrizzlyUtils() {
    }

    public static Filter rpcMessageReceiverFor(Transport t) {
        if (t instanceof TCPNIOTransport) {
            return new RpcMessageParserTCP();
        }
        if (t instanceof UDPNIOTransport) {
            return new RpcMessageParserUDP();
        }
        throw new RuntimeException("Unsupported transport: " + t.getClass().getName());
    }

    public static Class<? extends Transport> transportFor(int protocol) {
        switch (protocol) {
            case 6: {
                return TCPNIOTransport.class;
            }
            case 17: {
                return UDPNIOTransport.class;
            }
        }
        throw new RuntimeException("Unsupported protocol: " + protocol);
    }

    private static int getSelectorPoolSize(IoStrategy ioStrategy) {
        return ioStrategy == IoStrategy.WORKER_THREAD ? Math.max(2, CPUS / 4) : Math.max(5, CPUS);
    }

    private static int getWorkerPoolSize(IoStrategy ioStrategy) {
        return ioStrategy == IoStrategy.WORKER_THREAD ? Math.max(5, CPUS * 2) : 0;
    }

    static ThreadPoolConfig getSelectorPoolCfg(IoStrategy ioStrategy, String serviceName) {
        int poolSize = GrizzlyUtils.getSelectorPoolSize(ioStrategy);
        ThreadPoolConfig poolCfg = ThreadPoolConfig.defaultConfig();
        poolCfg.setCorePoolSize(poolSize).setMaxPoolSize(poolSize);
        if (serviceName != null) {
            poolCfg.setPoolName(serviceName);
        }
        return poolCfg;
    }

    static ThreadPoolConfig getWorkerPoolCfg(IoStrategy ioStrategy, String serviceName) {
        if (ioStrategy == IoStrategy.SAME_THREAD) {
            return null;
        }
        int poolSize = GrizzlyUtils.getWorkerPoolSize(ioStrategy);
        ThreadPoolConfig poolCfg = ThreadPoolConfig.defaultConfig();
        poolCfg.setCorePoolSize(poolSize).setMaxPoolSize(poolSize);
        if (serviceName != null) {
            poolCfg.setPoolName(serviceName + " Worker");
        }
        return poolCfg;
    }

    static IOStrategy translate(IoStrategy ioStrategy) {
        switch (ioStrategy) {
            case SAME_THREAD: {
                return SameThreadIOStrategy.getInstance();
            }
            case WORKER_THREAD: {
                return WorkerThreadIOStrategy.getInstance();
            }
            case LEADER_FOLLOWER: {
                return LeaderFollowerNIOStrategy.getInstance();
            }
        }
        throw new UnsupportedOperationException("unhandled " + (Object)((Object)ioStrategy));
    }
}

