/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.RpcDispatchable;
import org.dcache.xdr.RpcException;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcDispatcher
extends BaseFilter {
    private static final Logger _log = LoggerFactory.getLogger(RpcDispatcher.class);
    private final Map<OncRpcProgram, RpcDispatchable> _programs;
    private final ExecutorService _asyncExecutorService;

    public RpcDispatcher(ExecutorService executor, Map<OncRpcProgram, RpcDispatchable> programs) throws NullPointerException {
        this._programs = Objects.requireNonNull(programs, "Programs is NULL");
        this._asyncExecutorService = Objects.requireNonNull(executor, "ExecutorService is NULL");
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        final RpcCall call = (RpcCall)ctx.getMessage();
        int prog = call.getProgram();
        int vers = call.getProgramVersion();
        int proc = call.getProcedure();
        _log.debug("processing request {}", (Object)call);
        final RpcDispatchable program = this._programs.get(new OncRpcProgram(prog, vers));
        this._asyncExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                if (program == null) {
                    call.failProgramUnavailable();
                } else {
                    try {
                        program.dispatchOncRpcCall(call);
                    }
                    catch (RpcException e) {
                        call.reject(e.getStatus(), e.getRpcReply());
                        _log.warn("Failed to process RPC request: {}", (Object)e.getMessage());
                    }
                    catch (OncRpcException e) {
                        call.failRpcGarbage();
                        _log.warn("Failed to process RPC request: {}", (Object)e.getMessage());
                    }
                    catch (IOException e) {
                        call.failRpcGarbage();
                        _log.warn("Failed to process RPC request: {}", (Object)e.getMessage());
                    }
                    catch (RuntimeException e) {
                        _log.error("Failed to process RPC request:", e);
                        call.failRpcSystem();
                    }
                    catch (Throwable t) {
                        _log.error("Failed to process RPC request:", t);
                        call.failRpcSystem();
                        throw t;
                    }
                }
            }

            public String toString() {
                return call.toString();
            }
        });
        return ctx.getInvokeAction();
    }
}

