/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.dcache.xdr.GrizzlyUtils;
import org.dcache.xdr.IoStrategy;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.OncRpcSvc;
import org.dcache.xdr.RpcDispatchable;
import org.dcache.xdr.gss.GssSessionManager;
import org.glassfish.grizzly.threadpool.FixedThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class OncRpcSvcBuilder {
    private int _protocol = 0;
    private int _minPort = 0;
    private int _maxPort = 0;
    private boolean _autoPublish = true;
    private IoStrategy _ioStrategy = IoStrategy.SAME_THREAD;
    private boolean _withJMX = false;
    private int _backlog = 4096;
    private String _bindAddress = "0.0.0.0";
    private String _serviceName = "OncRpcSvc";
    private GssSessionManager _gssSessionManager;
    private ExecutorService _workerThreadExecutionService;
    private boolean _isClient = false;
    private final Map<OncRpcProgram, RpcDispatchable> _programs = new HashMap<OncRpcProgram, RpcDispatchable>();

    public OncRpcSvcBuilder withAutoPublish() {
        this._autoPublish = true;
        return this;
    }

    public OncRpcSvcBuilder withoutAutoPublish() {
        this._autoPublish = false;
        return this;
    }

    public OncRpcSvcBuilder withMaxPort(int maxPort) {
        Preconditions.checkArgument(maxPort >= 0, "Illegal max port value");
        this._maxPort = maxPort;
        this._minPort = Math.min(this._minPort, this._maxPort);
        return this;
    }

    public OncRpcSvcBuilder withMinPort(int minPort) {
        Preconditions.checkArgument(minPort >= 0, "Illegal min port value");
        this._minPort = minPort;
        this._maxPort = Math.max(this._minPort, this._maxPort);
        return this;
    }

    public OncRpcSvcBuilder withPort(int port) {
        Preconditions.checkArgument(port >= 0, "Illegal port value");
        this._minPort = this._maxPort = port;
        return this;
    }

    public OncRpcSvcBuilder withTCP() {
        this._protocol |= 6;
        return this;
    }

    public OncRpcSvcBuilder withUDP() {
        this._protocol |= 0x11;
        return this;
    }

    public OncRpcSvcBuilder withIpProtocolType(int protocolType) {
        this._protocol = protocolType;
        return this;
    }

    public OncRpcSvcBuilder withSameThreadIoStrategy() {
        this._ioStrategy = IoStrategy.SAME_THREAD;
        return this;
    }

    public OncRpcSvcBuilder withWorkerThreadIoStrategy() {
        this._ioStrategy = IoStrategy.WORKER_THREAD;
        return this;
    }

    public OncRpcSvcBuilder withIoStrategy(IoStrategy ioStrategy) {
        this._ioStrategy = ioStrategy;
        return this;
    }

    public OncRpcSvcBuilder withJMX() {
        this._withJMX = true;
        return this;
    }

    public OncRpcSvcBuilder withBacklog(int backlog) {
        this._backlog = backlog;
        return this;
    }

    public OncRpcSvcBuilder withBindAddress(String address) {
        this._bindAddress = address;
        return this;
    }

    public OncRpcSvcBuilder withServiceName(String serviceName) {
        this._serviceName = serviceName;
        return this;
    }

    public OncRpcSvcBuilder withGssSessionManager(GssSessionManager gssSessionManager) {
        this._gssSessionManager = gssSessionManager;
        return this;
    }

    public OncRpcSvcBuilder withWorkerThreadExecutionService(ExecutorService executorService) {
        this._workerThreadExecutionService = executorService;
        return this;
    }

    public OncRpcSvcBuilder withClientMode() {
        this._isClient = true;
        return this;
    }

    public OncRpcSvcBuilder withRpcService(OncRpcProgram program, RpcDispatchable service) {
        this._programs.put(program, service);
        return this;
    }

    public int getProtocol() {
        return this._protocol;
    }

    public int getMinPort() {
        return this._minPort;
    }

    public int getMaxPort() {
        return this._maxPort;
    }

    public boolean isAutoPublish() {
        return this._autoPublish;
    }

    public IoStrategy getIoStrategy() {
        return this._ioStrategy;
    }

    public boolean isWithJMX() {
        return this._withJMX;
    }

    public int getBacklog() {
        return this._backlog;
    }

    public String getBindAddress() {
        return this._bindAddress;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public GssSessionManager getGssSessionManager() {
        return this._gssSessionManager;
    }

    public ExecutorService getWorkerThreadExecutorService() {
        if (this._ioStrategy == IoStrategy.SAME_THREAD) {
            return MoreExecutors.newDirectExecutorService();
        }
        if (this._workerThreadExecutionService != null) {
            return this._workerThreadExecutionService;
        }
        ThreadPoolConfig workerPoolConfig = GrizzlyUtils.getWorkerPoolCfg(this._ioStrategy, this._serviceName);
        return new FixedThreadPool(workerPoolConfig);
    }

    public boolean isClient() {
        return this._isClient;
    }

    public Map<OncRpcProgram, RpcDispatchable> getRpcServices() {
        return this._programs;
    }

    public OncRpcSvc build() {
        if (this._protocol == 0 || (this._protocol & 6) != 6 && (this._protocol & 0x11) != 17) {
            throw new IllegalArgumentException("invalid protocol: " + this._protocol);
        }
        if (this._isClient && this._protocol == 23) {
            throw new IllegalArgumentException("Client mode can't be TCP and UDP at the same time");
        }
        if (this._isClient && this._maxPort != this._minPort) {
            throw new IllegalArgumentException("Can't use port range in client mode");
        }
        return new OncRpcSvc(this);
    }
}

