/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

public class JdkVersion
implements Comparable<JdkVersion> {
    private static final boolean IS_UNSAFE_SUPPORTED;
    private static final JdkVersion UNKNOWN_VERSION;
    private static final JdkVersion JDK_VERSION;
    private final int major;
    private final int minor;
    private final int maintenance;
    private final int update;

    private JdkVersion(int major, int minor, int maintenance, int update) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.update = update;
    }

    public static JdkVersion parseVersion(String versionString) {
        try {
            String[] parts;
            int dashIdx = versionString.indexOf(45);
            if (dashIdx != -1) {
                versionString = versionString.substring(0, dashIdx);
            }
            if ((parts = versionString.split("\\.|_")).length == 3) {
                return new JdkVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), 0);
            }
            return new JdkVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
        }
        catch (Exception e) {
            return UNKNOWN_VERSION;
        }
    }

    public static JdkVersion getJdkVersion() {
        return JDK_VERSION;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMaintenance() {
        return this.maintenance;
    }

    public int getUpdate() {
        return this.update;
    }

    public boolean isUnsafeSupported() {
        return IS_UNSAFE_SUPPORTED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JdkVersion");
        sb.append("{major=").append(this.major);
        sb.append(", minor=").append(this.minor);
        sb.append(", maintenance=").append(this.maintenance);
        sb.append(", update=").append(this.update);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(String versionString) {
        return this.compareTo(JdkVersion.parseVersion(versionString));
    }

    @Override
    public int compareTo(JdkVersion otherVersion) {
        if (this.major < otherVersion.major) {
            return -1;
        }
        if (this.major > otherVersion.major) {
            return 1;
        }
        if (this.minor < otherVersion.minor) {
            return -1;
        }
        if (this.minor > otherVersion.minor) {
            return 1;
        }
        if (this.maintenance < otherVersion.maintenance) {
            return -1;
        }
        if (this.maintenance > otherVersion.maintenance) {
            return 1;
        }
        if (this.update < otherVersion.update) {
            return -1;
        }
        if (this.update > otherVersion.update) {
            return 1;
        }
        return 0;
    }

    static {
        boolean isUnsafeFound;
        try {
            isUnsafeFound = Class.forName("sun.misc.Unsafe") != null;
        }
        catch (Throwable t) {
            isUnsafeFound = false;
        }
        IS_UNSAFE_SUPPORTED = isUnsafeFound;
        UNKNOWN_VERSION = new JdkVersion(-1, -1, -1, -1);
        JDK_VERSION = JdkVersion.parseVersion(System.getProperty("java.version"));
    }
}

