/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import org.springframework.aop.aspectj.SingletonAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;

public class SingletonMetadataAwareAspectInstanceFactory
extends SingletonAspectInstanceFactory
implements MetadataAwareAspectInstanceFactory {
    private final AspectMetadata metadata;

    public SingletonMetadataAwareAspectInstanceFactory(Object aspectInstance, String aspectName) {
        super(aspectInstance);
        this.metadata = new AspectMetadata(aspectInstance.getClass(), aspectName);
    }

    @Override
    public final AspectMetadata getAspectMetadata() {
        return this.metadata;
    }

    @Override
    protected int getOrderForAspectClass(Class<?> aspectClass) {
        Order order = AnnotationUtils.findAnnotation(aspectClass, Order.class);
        if (order != null) {
            return order.value();
        }
        return Integer.MAX_VALUE;
    }
}

