/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr.portmap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.utils.net.InetSocketAddresses;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrBoolean;
import org.dcache.xdr.XdrInt;
import org.dcache.xdr.XdrVoid;
import org.dcache.xdr.netid;
import org.dcache.xdr.portmap.OncPortmapClient;
import org.dcache.xdr.portmap.mapping;
import org.dcache.xdr.portmap.pmaplist;
import org.dcache.xdr.portmap.rpcb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortmapV2Client
implements OncPortmapClient {
    private static final Logger _log = LoggerFactory.getLogger(PortmapV2Client.class);
    private final RpcCall _call;

    public PortmapV2Client(RpcCall call) {
        this._call = call;
    }

    @Override
    public List<rpcb> dump() throws OncRpcException, IOException, TimeoutException {
        _log.debug("portmap dump");
        pmaplist list_reply = new pmaplist();
        this._call.call(4, (XdrAble)XdrVoid.XDR_VOID, list_reply);
        LinkedList<rpcb> out = new LinkedList<rpcb>();
        out.add(new rpcb(list_reply.getEntry()));
        while ((list_reply = list_reply.getNext()) != null) {
            mapping c = list_reply.getEntry();
            if (c == null) continue;
            out.add(new rpcb(c));
        }
        return out;
    }

    @Override
    public boolean ping() {
        _log.debug("portmap ping");
        boolean pong = false;
        try {
            this._call.call(0, (XdrAble)XdrVoid.XDR_VOID, XdrVoid.XDR_VOID, 2L, TimeUnit.SECONDS);
            pong = true;
        }
        catch (IOException | TimeoutException exception) {
            // empty catch block
        }
        return pong;
    }

    @Override
    public boolean setPort(int program, int version, String netids, String addr, String owner) throws OncRpcException, IOException, TimeoutException {
        _log.debug("portmap set port: prog: {} vers: {}, netid: {} addr: {}, owner: {}", program, version, netids, addr, owner);
        InetSocketAddress address = netid.toInetSocketAddress(addr);
        mapping m1 = new mapping(program, version, netid.idOf(netids), address.getPort());
        XdrBoolean isSet = new XdrBoolean();
        this._call.call(1, (XdrAble)m1, isSet);
        return isSet.booleanValue();
    }

    @Override
    public boolean unsetPort(int program, int version, String owner) throws OncRpcException, IOException, TimeoutException {
        _log.debug("portmap unset port: prog: {} vers: {}, owner: {}", program, version, owner);
        mapping m = new mapping(program, version, 0, -1);
        XdrBoolean isSet = new XdrBoolean();
        this._call.call(2, (XdrAble)m, isSet);
        return isSet.booleanValue();
    }

    @Override
    public String getPort(int program, int version, String nid) throws OncRpcException, IOException, TimeoutException {
        mapping m = new mapping(program, version, netid.idOf(nid), 0);
        XdrInt port = new XdrInt();
        this._call.call(3, (XdrAble)m, port);
        return InetSocketAddresses.uaddrOf(this._call.getTransport().getRemoteSocketAddress().getAddress().getHostAddress(), port.intValue());
    }
}

