/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr.gss;

import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

class JaasConfigGenerator {
    private static final String jaasConfigTemplate = "com.sun.security.jgss.accept {\n  com.sun.security.auth.module.Krb5LoginModule required\n  debug=false\n  principal=\"%s\"\n  doNotPrompt=true\n  useKeyTab=true\n  keyTab=\"%s\"\n  debug=false\n  isInitiator=false\n  storeKey=true;\n};";

    JaasConfigGenerator() {
    }

    public static String generateJaasConfig(String servicePrincipal, String keytab) throws IOException {
        File jaasFile = File.createTempFile("jaas", ".conf");
        jaasFile.deleteOnExit();
        jaasFile.setExecutable(false);
        jaasFile.setReadable(true, true);
        jaasFile.setWritable(true, true);
        String config = String.format(jaasConfigTemplate, servicePrincipal, keytab);
        try (BufferedWriter bw = Files.newWriter(jaasFile, StandardCharsets.UTF_8);){
            bw.write(config, 0, config.length());
        }
        return jaasFile.getAbsolutePath();
    }
}

