/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.util.ObjectUtils;

public class SpringCacheAnnotationParser
implements CacheAnnotationParser,
Serializable {
    @Override
    public Collection<CacheOperation> parseCacheAnnotations(AnnotatedElement ae) {
        Collection<Caching> collection;
        Collection<CachePut> collection2;
        Collection<CacheEvict> evicts;
        Collection<CacheOperation> ops = null;
        Collection<Cacheable> cacheables = this.getAnnotations(ae, Cacheable.class);
        if (cacheables != null) {
            ops = this.lazyInit(ops);
            for (Cacheable cacheable : cacheables) {
                ops.add(this.parseCacheableAnnotation(ae, cacheable));
            }
        }
        if ((evicts = this.getAnnotations(ae, CacheEvict.class)) != null) {
            ops = this.lazyInit(ops);
            for (CacheEvict cacheEvict : evicts) {
                ops.add(this.parseEvictAnnotation(ae, cacheEvict));
            }
        }
        if ((collection2 = this.getAnnotations(ae, CachePut.class)) != null) {
            ops = this.lazyInit(ops);
            for (CachePut p : collection2) {
                ops.add(this.parseUpdateAnnotation(ae, p));
            }
        }
        if ((collection = this.getAnnotations(ae, Caching.class)) != null) {
            ops = this.lazyInit(ops);
            for (Caching c : collection) {
                ops.addAll(this.parseCachingAnnotation(ae, c));
            }
        }
        return ops;
    }

    private <T extends Annotation> Collection<CacheOperation> lazyInit(Collection<CacheOperation> ops) {
        return ops != null ? ops : new ArrayList(1);
    }

    CacheableOperation parseCacheableAnnotation(AnnotatedElement ae, Cacheable caching) {
        CacheableOperation cuo = new CacheableOperation();
        cuo.setCacheNames(caching.value());
        cuo.setCondition(caching.condition());
        cuo.setUnless(caching.unless());
        cuo.setKey(caching.key());
        cuo.setName(ae.toString());
        return cuo;
    }

    CacheEvictOperation parseEvictAnnotation(AnnotatedElement ae, CacheEvict caching) {
        CacheEvictOperation ceo = new CacheEvictOperation();
        ceo.setCacheNames(caching.value());
        ceo.setCondition(caching.condition());
        ceo.setKey(caching.key());
        ceo.setCacheWide(caching.allEntries());
        ceo.setBeforeInvocation(caching.beforeInvocation());
        ceo.setName(ae.toString());
        return ceo;
    }

    CacheOperation parseUpdateAnnotation(AnnotatedElement ae, CachePut caching) {
        CachePutOperation cuo = new CachePutOperation();
        cuo.setCacheNames(caching.value());
        cuo.setCondition(caching.condition());
        cuo.setUnless(caching.unless());
        cuo.setKey(caching.key());
        cuo.setName(ae.toString());
        return cuo;
    }

    Collection<CacheOperation> parseCachingAnnotation(AnnotatedElement ae, Caching caching) {
        Object[] updates;
        Object[] evicts;
        Collection<CacheOperation> ops = null;
        Object[] cacheables = caching.cacheable();
        if (!ObjectUtils.isEmpty(cacheables)) {
            ops = this.lazyInit(ops);
            for (Object cacheable : cacheables) {
                ops.add(this.parseCacheableAnnotation(ae, (Cacheable)cacheable));
            }
        }
        if (!ObjectUtils.isEmpty(evicts = caching.evict())) {
            ops = this.lazyInit(ops);
            for (Object evict : evicts) {
                ops.add(this.parseEvictAnnotation(ae, (CacheEvict)evict));
            }
        }
        if (!ObjectUtils.isEmpty(updates = caching.put())) {
            ops = this.lazyInit(ops);
            for (Object update : updates) {
                ops.add(this.parseUpdateAnnotation(ae, (CachePut)update));
            }
        }
        return ops;
    }

    private <T extends Annotation> Collection<T> getAnnotations(AnnotatedElement ae, Class<T> annotationType) {
        ArrayList<T> anns = new ArrayList<T>(2);
        T ann = ae.getAnnotation(annotationType);
        if (ann != null) {
            anns.add(ann);
        }
        for (Annotation metaAnn : ae.getAnnotations()) {
            ann = metaAnn.annotationType().getAnnotation(annotationType);
            if (ann == null) continue;
            anns.add(ann);
        }
        return anns.isEmpty() ? null : anns;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SpringCacheAnnotationParser;
    }

    public int hashCode() {
        return SpringCacheAnnotationParser.class.hashCode();
    }
}

