/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.dcache.xdr.IoStrategy;
import org.dcache.xdr.OncRpcSvc;
import org.dcache.xdr.OncRpcSvcBuilder;
import org.dcache.xdr.XdrTransport;

public class OncRpcClient
implements AutoCloseable {
    private final InetSocketAddress _socketAddress;
    private final OncRpcSvc _rpcsvc;

    public OncRpcClient(InetAddress address, int protocol, int port) {
        this(new InetSocketAddress(address, port), protocol, 0, IoStrategy.SAME_THREAD);
    }

    public OncRpcClient(InetAddress address, int protocol, int port, int localPort) {
        this(new InetSocketAddress(address, port), protocol, localPort, IoStrategy.SAME_THREAD);
    }

    public OncRpcClient(InetAddress address, int protocol, int port, int localPort, IoStrategy ioStrategy) {
        this(new InetSocketAddress(address, port), protocol, localPort, ioStrategy);
    }

    public OncRpcClient(InetSocketAddress socketAddress, int protocol) {
        this(socketAddress, protocol, 0, IoStrategy.SAME_THREAD);
    }

    public OncRpcClient(InetSocketAddress socketAddress, int protocol, int localPort, IoStrategy ioStrategy) {
        this._socketAddress = socketAddress;
        this._rpcsvc = new OncRpcSvcBuilder().withClientMode().withPort(localPort).withIpProtocolType(protocol).withIoStrategy(ioStrategy).build();
    }

    public XdrTransport connect() throws IOException {
        return this.connect(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public XdrTransport connect(long timeout, TimeUnit timeUnit) throws IOException {
        XdrTransport t;
        try {
            this._rpcsvc.start();
            t = this._rpcsvc.connect(this._socketAddress, timeout, timeUnit);
        }
        catch (IOException e) {
            this._rpcsvc.stop();
            throw e;
        }
        return t;
    }

    @Override
    public void close() throws IOException {
        this._rpcsvc.stop();
    }
}

