/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BeansDtdResolver
implements EntityResolver {
    private static final String DTD_EXTENSION = ".dtd";
    private static final String[] DTD_NAMES = new String[]{"spring-beans-2.0", "spring-beans"};
    private static final Log logger = LogFactory.getLog(BeansDtdResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("Trying to resolve XML entity with public ID [" + publicId + "] and system ID [" + systemId + "]");
        }
        if (systemId != null && systemId.endsWith(DTD_EXTENSION)) {
            int lastPathSeparator = systemId.lastIndexOf("/");
            for (String DTD_NAME : DTD_NAMES) {
                int dtdNameStart = systemId.indexOf(DTD_NAME);
                if (dtdNameStart <= lastPathSeparator) continue;
                String dtdFile = systemId.substring(dtdNameStart);
                if (logger.isTraceEnabled()) {
                    logger.trace("Trying to locate [" + dtdFile + "] in Spring jar");
                }
                try {
                    ClassPathResource resource = new ClassPathResource(dtdFile, this.getClass());
                    InputSource source = new InputSource(resource.getInputStream());
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found beans DTD [" + systemId + "] in classpath: " + dtdFile);
                    }
                    return source;
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Could not resolve beans DTD [" + systemId + "]: not found in class path", ex);
                }
            }
        }
        return null;
    }

    public String toString() {
        return "EntityResolver for DTDs " + Arrays.toString(DTD_NAMES);
    }
}

