/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.grizzly;

import com.google.common.base.Preconditions;
import org.dcache.oncrpc4j.rpc.IoStrategy;
import org.dcache.oncrpc4j.rpc.MemoryAllocator;
import org.dcache.oncrpc4j.rpc.RpcMessageParserTCP;
import org.dcache.oncrpc4j.rpc.RpcMessageParserUDP;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.memory.ByteBufferManager;
import org.glassfish.grizzly.memory.HeapMemoryManager;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.PooledMemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.strategies.LeaderFollowerNIOStrategy;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class GrizzlyUtils {
    static final int MIN_SELECTORS = 2;
    static final int MIN_WORKERS = 5;
    static final int CPUS = Runtime.getRuntime().availableProcessors();

    private GrizzlyUtils() {
    }

    public static Filter rpcMessageReceiverFor(Transport t) {
        if (t instanceof TCPNIOTransport) {
            return new RpcMessageParserTCP();
        }
        if (t instanceof UDPNIOTransport) {
            return new RpcMessageParserUDP();
        }
        throw new RuntimeException("Unsupported transport: " + t.getClass().getName());
    }

    public static Class<? extends Transport> transportFor(int protocol) {
        switch (protocol) {
            case 6: {
                return TCPNIOTransport.class;
            }
            case 17: {
                return UDPNIOTransport.class;
            }
        }
        throw new RuntimeException("Unsupported protocol: " + protocol);
    }

    private static int getSelectorPoolSize(IoStrategy ioStrategy) {
        return ioStrategy == IoStrategy.WORKER_THREAD ? Math.max(2, CPUS / 4) : Math.max(5, CPUS);
    }

    public static int getDefaultWorkerPoolSize() {
        return Math.max(5, CPUS * 2);
    }

    public static ThreadPoolConfig getSelectorPoolCfg(IoStrategy ioStrategy, String serviceName, int poolSize) {
        Preconditions.checkArgument(poolSize >= 0, "Negative  thread pool size");
        int threadPoolSize = poolSize > 0 ? Math.max(poolSize, 2) : GrizzlyUtils.getSelectorPoolSize(ioStrategy);
        ThreadPoolConfig poolCfg = ThreadPoolConfig.defaultConfig();
        poolCfg.setCorePoolSize(threadPoolSize).setMaxPoolSize(threadPoolSize);
        if (serviceName != null) {
            poolCfg.setPoolName(serviceName);
        }
        return poolCfg;
    }

    public static MemoryManager getMemoryManager(MemoryAllocator allocator) {
        switch (allocator) {
            case DEFAULT: {
                return MemoryManager.DEFAULT_MEMORY_MANAGER;
            }
            case HEAP: {
                return new HeapMemoryManager();
            }
            case DIRECT: {
                return new ByteBufferManager(true);
            }
            case POOLED_HEAP: {
                return new PooledMemoryManager(false);
            }
            case POOLED_DIRECT: {
                return new PooledMemoryManager(true);
            }
        }
        throw new RuntimeException("Unexpected memory allocator.");
    }

    public static IOStrategy getNIOStrategy(IoStrategy ioStrategy) {
        switch (ioStrategy) {
            case LEADER_FOLLOWER: {
                return LeaderFollowerNIOStrategy.getInstance();
            }
        }
        return SameThreadIOStrategy.getInstance();
    }
}

