/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.portmap;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.oncrpc4j.portmap.OncRpcbindServer;
import org.dcache.oncrpc4j.rpc.OncRpcClient;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvc;
import org.dcache.oncrpc4j.rpc.OncRpcSvcBuilder;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeNone;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrVoid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncRpcEmbeddedPortmap {
    private static final Logger LOG = LoggerFactory.getLogger(OncRpcEmbeddedPortmap.class);
    private static final RpcAuth _auth = new RpcAuthTypeNone();
    private OncRpcSvc optionalEmbeddedServer = null;

    public OncRpcEmbeddedPortmap() {
        this(2L, TimeUnit.SECONDS);
    }

    public OncRpcEmbeddedPortmap(long timeoutValue, TimeUnit timeoutUnit) {
        boolean localPortmapperRunning = false;
        try (OncRpcClient rpcClient2 = new OncRpcClient(InetAddress.getByName(null), 17, 111);){
            RpcTransport transport = rpcClient2.connect();
            for (int i = 4; i > 1 && !localPortmapperRunning; --i) {
                RpcCall call = new RpcCall(100000, i, _auth, transport);
                try {
                    call.call(0, (XdrAble)XdrVoid.XDR_VOID, XdrVoid.XDR_VOID, timeoutValue, timeoutUnit);
                    localPortmapperRunning = true;
                    LOG.info("Local portmap service v{} detected", (Object)i);
                    continue;
                }
                catch (TimeoutException | OncRpcException e) {
                    LOG.debug("portmap ping failed: {}", (Object)e.getMessage());
                }
            }
        }
        catch (IOException rpcClient2) {
            // empty catch block
        }
        if (!localPortmapperRunning) {
            try {
                LOG.info("Starting embedded portmap service");
                OncRpcSvc rpcbindServer = new OncRpcSvcBuilder().withPort(111).withTCP().withUDP().withoutAutoPublish().withRpcService(new OncRpcProgram(100000, 2), new OncRpcbindServer()).build();
                rpcbindServer.start();
                this.optionalEmbeddedServer = rpcbindServer;
            }
            catch (IOException e) {
                LOG.error("Failed to start embedded portmap service: {}", (Object)e.getMessage());
            }
        }
    }

    public boolean isEmbeddedPortmapper() {
        return this.optionalEmbeddedServer != null;
    }

    public void shutdown() throws IOException {
        if (this.optionalEmbeddedServer != null) {
            this.optionalEmbeddedServer.stop();
        }
    }
}

