/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.portmap;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.oncrpc4j.portmap.OncPortmapClient;
import org.dcache.oncrpc4j.portmap.rpcb;
import org.dcache.oncrpc4j.portmap.rpcb_list;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.RpcAuth;
import org.dcache.oncrpc4j.rpc.RpcAuthTypeNone;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.xdr.XdrAble;
import org.dcache.oncrpc4j.xdr.XdrBoolean;
import org.dcache.oncrpc4j.xdr.XdrString;
import org.dcache.oncrpc4j.xdr.XdrVoid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcbindV4Client
implements OncPortmapClient {
    private static final Logger _log = LoggerFactory.getLogger(RpcbindV4Client.class);
    private final RpcAuth _auth = new RpcAuthTypeNone();
    private final RpcCall _call;

    public RpcbindV4Client(RpcCall call) {
        this._call = call;
    }

    @Override
    public boolean ping() {
        _log.debug("portmap ping");
        boolean pong = false;
        try {
            this._call.call(0, (XdrAble)XdrVoid.XDR_VOID, XdrVoid.XDR_VOID, 2L, TimeUnit.SECONDS);
            pong = true;
        }
        catch (IOException | TimeoutException exception) {
            // empty catch block
        }
        return pong;
    }

    @Override
    public boolean setPort(int program, int version, String netid2, String addr, String owner) throws OncRpcException, IOException, TimeoutException {
        _log.debug("portmap set port: prog: {} vers: {}, netid: {} addr: {}, owner: {}", program, version, netid2, addr, owner);
        rpcb m1 = new rpcb(program, version, netid2, addr, owner);
        XdrBoolean isSet = new XdrBoolean();
        this._call.call(1, (XdrAble)m1, isSet);
        return isSet.booleanValue();
    }

    @Override
    public boolean unsetPort(int program, int version, String owner) throws OncRpcException, IOException, TimeoutException {
        _log.debug("portmap unset port: prog: {} vers: {}, owner: {}", program, version, owner);
        rpcb m3 = new rpcb(program, version, "", "", owner);
        XdrBoolean isSet = new XdrBoolean();
        this._call.call(2, (XdrAble)m3, isSet);
        return isSet.booleanValue();
    }

    @Override
    public String getPort(int program, int version, String netid2) throws OncRpcException, IOException, TimeoutException {
        rpcb arg = new rpcb(program, version, netid2, "", "");
        XdrString xdrString = new XdrString();
        this._call.call(3, (XdrAble)arg, xdrString);
        return xdrString.stringValue();
    }

    @Override
    public List<rpcb> dump() throws OncRpcException, IOException, TimeoutException {
        _log.debug("portmap dump");
        rpcb_list rpcb_list_reply = new rpcb_list();
        this._call.call(4, (XdrAble)XdrVoid.XDR_VOID, rpcb_list_reply);
        LinkedList<rpcb> out = new LinkedList<rpcb>();
        out.add(rpcb_list_reply.getEntry());
        while ((rpcb_list_reply = rpcb_list_reply.getNext()) != null) {
            rpcb c = rpcb_list_reply.getEntry();
            if (c == null) continue;
            out.add(c);
        }
        return out;
    }
}

