/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.dcache.oncrpc4j.grizzly.GrizzlyRpcTransport;
import org.dcache.oncrpc4j.grizzly.GrizzlyUtils;
import org.dcache.oncrpc4j.grizzly.StartTlsFilter;
import org.dcache.oncrpc4j.portmap.GenericPortmapClient;
import org.dcache.oncrpc4j.rpc.IoStrategy;
import org.dcache.oncrpc4j.rpc.OncRpcClient;
import org.dcache.oncrpc4j.rpc.OncRpcException;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvcBuilder;
import org.dcache.oncrpc4j.rpc.ReplyQueue;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;
import org.dcache.oncrpc4j.rpc.RpcDispatcher;
import org.dcache.oncrpc4j.rpc.RpcProgUnavailable;
import org.dcache.oncrpc4j.rpc.RpcProtocolFilter;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.dcache.oncrpc4j.rpc.gss.GssProtocolFilter;
import org.dcache.oncrpc4j.rpc.gss.GssSessionManager;
import org.dcache.oncrpc4j.rpc.net.InetSocketAddresses;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.SocketBinder;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.jmxbase.GrizzlyJmxManager;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncRpcSvc {
    private static final Logger _log = LoggerFactory.getLogger(OncRpcSvc.class);
    private final int _backlog;
    private final boolean _publish;
    private final PortRange _portRange;
    private final String _bindAddress;
    private final boolean _isClient;
    private final List<NIOTransport> _transports = new ArrayList<NIOTransport>();
    private final Set<Connection<InetSocketAddress>> _boundConnections = new HashSet<Connection<InetSocketAddress>>();
    private final ExecutorService _requestExecutor;
    private final ReplyQueue _replyQueue = new ReplyQueue();
    private final boolean _withSubjectPropagation;
    private final GssSessionManager _gssSessionManager;
    private final SSLContext _sslContext;
    private final SSLParameters _sslParams;
    private final boolean _startTLS;
    private final Map<OncRpcProgram, RpcDispatchable> _programs = new ConcurrentHashMap<OncRpcProgram, RpcDispatchable>();
    private final String _svcName;
    private final Consumer<RpcCall> _callInterceptor;

    OncRpcSvc(OncRpcSvcBuilder builder) {
        this._publish = builder.isAutoPublish();
        int protocol = builder.getProtocol();
        if ((protocol & 0x17) == 0) {
            throw new IllegalArgumentException("TCP or UDP protocol have to be defined");
        }
        MemoryManager mm3 = GrizzlyUtils.getMemoryManager(builder.getMemoryAllocator());
        IoStrategy ioStrategy = builder.getIoStrategy();
        String serviceName = builder.getServiceName();
        ThreadPoolConfig selectorPoolConfig = GrizzlyUtils.getSelectorPoolCfg(ioStrategy, serviceName, builder.getSelectorThreadPoolSize());
        if ((protocol & 6) != 0) {
            TCPNIOTransport tcpTransport = ((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setReuseAddress(true)).setIOStrategy(GrizzlyUtils.getNIOStrategy(ioStrategy))).setSelectorThreadPoolConfig(selectorPoolConfig)).setSelectorRunnersCount(selectorPoolConfig.getMaxPoolSize())).setMemoryManager(mm3)).build();
            this._transports.add(tcpTransport);
        }
        if ((protocol & 0x11) != 0) {
            UDPNIOTransport udpTransport = ((UDPNIOTransportBuilder)((UDPNIOTransportBuilder)((UDPNIOTransportBuilder)((UDPNIOTransportBuilder)((UDPNIOTransportBuilder)UDPNIOTransportBuilder.newInstance().setReuseAddress(true)).setIOStrategy(GrizzlyUtils.getNIOStrategy(ioStrategy))).setSelectorThreadPoolConfig(selectorPoolConfig)).setSelectorRunnersCount(selectorPoolConfig.getMaxPoolSize())).setMemoryManager(mm3)).build();
            this._transports.add(udpTransport);
        }
        this._isClient = builder.isClient();
        this._portRange = builder.getMinPort() > 0 ? new PortRange(builder.getMinPort(), builder.getMaxPort()) : null;
        this._backlog = builder.getBacklog();
        this._bindAddress = builder.getBindAddress();
        if (builder.isWithJMX()) {
            GrizzlyJmxManager jmxManager = GrizzlyJmxManager.instance();
            this._transports.forEach(t -> jmxManager.registerAtRoot(t.getMonitoringConfig().createManagementObject(), t.getName() + "-" + this._portRange));
        }
        this._requestExecutor = builder.getWorkerThreadExecutorService();
        this._gssSessionManager = builder.getGssSessionManager();
        this._programs.putAll(builder.getRpcServices());
        this._withSubjectPropagation = builder.getSubjectPropagation();
        this._svcName = builder.getServiceName();
        this._sslContext = builder.getSSLContext();
        this._startTLS = builder.isStartTLS();
        this._sslParams = builder.getSSLParameters();
        this._callInterceptor = builder.getCallInterceptor();
    }

    public void register(OncRpcProgram prog, RpcDispatchable handler) {
        _log.info("Registering new program {} : {}", (Object)prog, (Object)handler);
        this._programs.put(prog, handler);
    }

    public void unregister(OncRpcProgram prog) {
        _log.info("Unregistering program {}", (Object)prog);
        this._programs.remove(prog);
    }

    @Deprecated
    public void setPrograms(Map<OncRpcProgram, RpcDispatchable> services) {
        this._programs.putAll(services);
    }

    private void publishToPortmap(Connection<InetSocketAddress> connection, Set<OncRpcProgram> programs) throws IOException {
        try (OncRpcClient rpcClient = new OncRpcClient(InetAddress.getByName(null), 17, 111);){
            String netidBase;
            RpcTransport transport = rpcClient.connect();
            GenericPortmapClient portmapClient = new GenericPortmapClient(transport);
            HashSet<Object> netids = new HashSet<Object>();
            String username = System.getProperty("user.name");
            Transport t = connection.getTransport();
            String uaddr = InetSocketAddresses.uaddrOf(connection.getLocalAddress());
            if (t instanceof TCPNIOTransport) {
                netidBase = "tcp";
            } else if (t instanceof UDPNIOTransport) {
                netidBase = "udp";
            } else {
                throw new RuntimeException("Unsupported transport type: " + t.getClass().getCanonicalName());
            }
            InetAddress localAddress = connection.getLocalAddress().getAddress();
            if (localAddress instanceof Inet6Address) {
                netids.add(netidBase + "6");
                if (((Inet6Address)localAddress).isIPv4CompatibleAddress()) {
                    netids.add(netidBase);
                }
            } else {
                netids.add(netidBase);
            }
            for (OncRpcProgram program : programs) {
                for (String string : netids) {
                    try {
                        portmapClient.setPort(program.getNumber(), program.getVersion(), string, uaddr, username);
                    }
                    catch (TimeoutException | OncRpcException e) {
                        _log.warn("Failed to register program: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        catch (RpcProgUnavailable e) {
            _log.warn("Failed to register at portmap: {}", (Object)e.getMessage());
        }
    }

    private void clearPortmap(Set<OncRpcProgram> programs) throws IOException {
        try (OncRpcClient rpcClient = new OncRpcClient(InetAddress.getByName(null), 17, 111);){
            RpcTransport transport = rpcClient.connect();
            GenericPortmapClient portmapClient = new GenericPortmapClient(transport);
            String username = System.getProperty("user.name");
            for (OncRpcProgram program : programs) {
                try {
                    portmapClient.unsetPort(program.getNumber(), program.getVersion(), username);
                }
                catch (TimeoutException | OncRpcException e) {
                    _log.info("Failed to unregister program: {}", (Object)e.getMessage());
                }
            }
        }
        catch (RpcProgUnavailable e) {
            _log.info("portmap service not available");
        }
    }

    public void start() throws IOException {
        if (!this._isClient && this._publish) {
            this.clearPortmap(this._programs.keySet());
        }
        for (Transport transport : this._transports) {
            FilterChainBuilder filterChain = FilterChainBuilder.stateless();
            filterChain.add(new TransportFilter());
            if (this._sslContext != null) {
                SSLEngineConfigurator serverSSLEngineConfigurator = new SSLEngineConfigurator(this._sslContext, false, false, false);
                SSLEngineConfigurator clientSSLEngineConfigurator = new SSLEngineConfigurator(this._sslContext, true, false, false);
                if (this._sslParams != null) {
                    String[] cipherSuites = this._sslParams.getCipherSuites();
                    serverSSLEngineConfigurator.setEnabledCipherSuites(cipherSuites);
                    clientSSLEngineConfigurator.setEnabledCipherSuites(cipherSuites);
                    String[] protocols = this._sslParams.getProtocols();
                    serverSSLEngineConfigurator.setEnabledProtocols(protocols);
                    clientSSLEngineConfigurator.setEnabledProtocols(protocols);
                    serverSSLEngineConfigurator.setNeedClientAuth(this._sslParams.getNeedClientAuth());
                    serverSSLEngineConfigurator.setWantClientAuth(this._sslParams.getWantClientAuth());
                }
                SSLFilter sslFilter = new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator);
                filterChain.add(this._startTLS ? new StartTlsFilter(sslFilter, this._isClient) : sslFilter);
            }
            filterChain.add(GrizzlyUtils.rpcMessageReceiverFor(transport));
            filterChain.add(new RpcProtocolFilter(this._replyQueue));
            if (this._gssSessionManager != null) {
                filterChain.add(new GssProtocolFilter(this._gssSessionManager));
            }
            filterChain.add(new RpcDispatcher(this._requestExecutor, this._programs, this._withSubjectPropagation, this._callInterceptor));
            FilterChain filters = filterChain.build();
            transport.setProcessor(filters);
            transport.getConnectionMonitoringConfig().addProbes((ConnectionProbe[])new ConnectionProbe[]{new ConnectionProbe.Adapter(){

                @Override
                public void onCloseEvent(Connection connection) {
                    if (connection.getCloseReason().getType() == CloseType.REMOTELY) {
                        OncRpcSvc.this._replyQueue.handleDisconnect((SocketAddress)connection.getLocalAddress());
                    }
                }
            }});
            if (!this._isClient) {
                Connection<InetSocketAddress> connection = this._portRange == null ? ((SocketBinder)((Object)transport)).bind(this._bindAddress, 0, this._backlog) : ((SocketBinder)((Object)transport)).bind(this._bindAddress, this._portRange, this._backlog);
                this._boundConnections.add(connection);
                if (this._publish) {
                    this.publishToPortmap(connection, this._programs.keySet());
                }
            }
            transport.start();
        }
    }

    public void stop() throws IOException {
        if (!this._isClient && this._publish) {
            this.clearPortmap(this._programs.keySet());
        }
        for (Transport transport : this._transports) {
            transport.shutdownNow();
        }
        this._replyQueue.shutdown();
        this._requestExecutor.shutdown();
    }

    public void stop(long gracePeriod, TimeUnit timeUnit) throws IOException {
        if (!this._isClient && this._publish) {
            this.clearPortmap(this._programs.keySet());
        }
        ArrayList<GrizzlyFuture<Transport>> transportsShuttingDown = new ArrayList<GrizzlyFuture<Transport>>();
        for (Transport transport : this._transports) {
            transportsShuttingDown.add(transport.shutdown(gracePeriod, timeUnit));
        }
        for (GrizzlyFuture grizzlyFuture : transportsShuttingDown) {
            try {
                grizzlyFuture.get();
            }
            catch (InterruptedException e) {
                _log.info("Waiting for graceful shut down interrupted");
            }
            catch (ExecutionException e) {
                Throwable t = Throwables.getRootCause(e);
                _log.warn("Exception while waiting for transport to shut down gracefully", t);
            }
        }
        this._requestExecutor.shutdown();
    }

    public RpcTransport connect(InetSocketAddress socketAddress) throws IOException {
        return this.connect(socketAddress, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public RpcTransport connect(InetSocketAddress socketAddress, long timeout, TimeUnit timeUnit) throws IOException {
        Future<Connection> connectFuture;
        NIOTransport transport = this._transports.get(0);
        if (this._portRange != null) {
            InetSocketAddress localAddress = new InetSocketAddress(this._portRange.getLower());
            connectFuture = transport.connect(socketAddress, localAddress);
        } else {
            connectFuture = transport.connect(socketAddress);
        }
        try {
            Connection connection = connectFuture.get(timeout, timeUnit);
            return new GrizzlyRpcTransport(connection, this._replyQueue);
        }
        catch (ExecutionException e) {
            Throwable t = Throwables.getRootCause(e);
            Throwables.propagateIfPossible(t, IOException.class);
            throw new IOException(e.toString(), e);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IOException(e.toString(), e);
        }
    }

    public InetSocketAddress getInetSocketAddress(int protocol) {
        Class<? extends Transport> transportClass = GrizzlyUtils.transportFor(protocol);
        return this._boundConnections.stream().filter(c -> c.getTransport().getClass() == transportClass).map(Connection::getLocalAddress).findAny().orElse(null);
    }

    public String getName() {
        return this._svcName;
    }

    public String toString() {
        return this._boundConnections.stream().map(Connection::getLocalAddress).map(Object::toString).collect(Collectors.joining(",", this.getName() + "-[", "]"));
    }
}

