/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.dcache.oncrpc4j.grizzly.GrizzlyUtils;
import org.dcache.oncrpc4j.rpc.IoStrategy;
import org.dcache.oncrpc4j.rpc.MemoryAllocator;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvc;
import org.dcache.oncrpc4j.rpc.RpcCall;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;
import org.dcache.oncrpc4j.rpc.gss.GssSessionManager;

public class OncRpcSvcBuilder {
    private int _protocol = 0;
    private int _minPort = 0;
    private int _maxPort = 0;
    private boolean _autoPublish = true;
    private IoStrategy _ioStrategy = IoStrategy.SAME_THREAD;
    private boolean _withJMX = false;
    private int _backlog = 4096;
    private String _bindAddress = "0.0.0.0";
    private String _serviceName = "OncRpcSvc";
    private GssSessionManager _gssSessionManager;
    private ExecutorService _workerThreadExecutionService;
    private boolean _isClient = false;
    private final Map<OncRpcProgram, RpcDispatchable> _programs = new HashMap<OncRpcProgram, RpcDispatchable>();
    private int _selectorThreadPoolSize = 0;
    private int _workerThreadPoolSize = 0;
    private boolean _subjectPropagation = false;
    private SSLContext _sslContext = null;
    private boolean _startTLS = false;
    private SSLParameters _sslParams;
    private MemoryAllocator _allocator = MemoryAllocator.DEFAULT;
    private Consumer<RpcCall> _callInterceptor = c -> {};

    public OncRpcSvcBuilder withAutoPublish() {
        this._autoPublish = true;
        return this;
    }

    @Beta
    public OncRpcSvcBuilder withStartTLS() {
        this._startTLS = true;
        return this;
    }

    @Beta
    public OncRpcSvcBuilder withoutStartTLS() {
        this._startTLS = false;
        return this;
    }

    public OncRpcSvcBuilder withoutAutoPublish() {
        this._autoPublish = false;
        return this;
    }

    public OncRpcSvcBuilder withMaxPort(int maxPort) {
        Preconditions.checkArgument(maxPort >= 0, "Illegal max port value");
        this._maxPort = maxPort;
        this._minPort = Math.min(this._minPort, this._maxPort);
        return this;
    }

    public OncRpcSvcBuilder withMinPort(int minPort) {
        Preconditions.checkArgument(minPort >= 0, "Illegal min port value");
        this._minPort = minPort;
        this._maxPort = Math.max(this._minPort, this._maxPort);
        return this;
    }

    public OncRpcSvcBuilder withPort(int port) {
        Preconditions.checkArgument(port >= 0, "Illegal port value");
        this._minPort = this._maxPort = port;
        return this;
    }

    public OncRpcSvcBuilder withTCP() {
        this._protocol |= 6;
        return this;
    }

    public OncRpcSvcBuilder withUDP() {
        this._protocol |= 0x11;
        return this;
    }

    public OncRpcSvcBuilder withIpProtocolType(int protocolType) {
        this._protocol = protocolType;
        return this;
    }

    public OncRpcSvcBuilder withSameThreadIoStrategy() {
        this._ioStrategy = IoStrategy.SAME_THREAD;
        return this;
    }

    public OncRpcSvcBuilder withSelectorThreadPoolSize(int threadPoolSize) {
        Preconditions.checkArgument(threadPoolSize > 0, "thread pool size must be positive");
        this._selectorThreadPoolSize = threadPoolSize;
        return this;
    }

    public OncRpcSvcBuilder withWorkerThreadIoStrategy() {
        this._ioStrategy = IoStrategy.WORKER_THREAD;
        return this;
    }

    public OncRpcSvcBuilder withWorkerThreadPoolSize(int threadPoolSize) {
        Preconditions.checkArgument(threadPoolSize > 0, "thread pool size must be positive");
        this._workerThreadPoolSize = threadPoolSize;
        return this;
    }

    public OncRpcSvcBuilder withIoStrategy(IoStrategy ioStrategy) {
        this._ioStrategy = ioStrategy;
        return this;
    }

    public OncRpcSvcBuilder withJMX() {
        this._withJMX = true;
        return this;
    }

    public OncRpcSvcBuilder withBacklog(int backlog) {
        this._backlog = backlog;
        return this;
    }

    public OncRpcSvcBuilder withBindAddress(String address) {
        this._bindAddress = address;
        return this;
    }

    public OncRpcSvcBuilder withServiceName(String serviceName) {
        this._serviceName = serviceName;
        return this;
    }

    public OncRpcSvcBuilder withGssSessionManager(GssSessionManager gssSessionManager) {
        this._gssSessionManager = gssSessionManager;
        return this;
    }

    public OncRpcSvcBuilder withWorkerThreadExecutionService(ExecutorService executorService) {
        this._workerThreadExecutionService = executorService;
        return this;
    }

    public OncRpcSvcBuilder withClientMode() {
        this._isClient = true;
        return this;
    }

    public OncRpcSvcBuilder withRpcService(OncRpcProgram program, RpcDispatchable service) {
        this._programs.put(program, service);
        return this;
    }

    public OncRpcSvcBuilder withSubjectPropagation() {
        this._subjectPropagation = true;
        return this;
    }

    public OncRpcSvcBuilder withoutSubjectPropagation() {
        this._subjectPropagation = false;
        return this;
    }

    public OncRpcSvcBuilder withSSLContext(SSLContext sslContext) {
        this._sslContext = sslContext;
        return this;
    }

    public OncRpcSvcBuilder withSSLParameters(SSLParameters sslParams) {
        this._sslParams = sslParams;
        return this;
    }

    public OncRpcSvcBuilder withMemoryAllocator(MemoryAllocator allocator) {
        this._allocator = allocator;
        return this;
    }

    public boolean getSubjectPropagation() {
        return this._subjectPropagation;
    }

    public int getProtocol() {
        return this._protocol;
    }

    public int getMinPort() {
        return this._minPort;
    }

    public int getMaxPort() {
        return this._maxPort;
    }

    public boolean isAutoPublish() {
        return this._autoPublish;
    }

    @Beta
    public boolean isStartTLS() {
        return this._startTLS;
    }

    public IoStrategy getIoStrategy() {
        return this._ioStrategy;
    }

    public boolean isWithJMX() {
        return this._withJMX;
    }

    public int getBacklog() {
        return this._backlog;
    }

    public String getBindAddress() {
        return this._bindAddress;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public GssSessionManager getGssSessionManager() {
        return this._gssSessionManager;
    }

    public OncRpcSvcBuilder withCallInterceptor(Consumer<RpcCall> interceptor) {
        this._callInterceptor = interceptor;
        return this;
    }

    public Consumer<RpcCall> getCallInterceptor() {
        return this._callInterceptor;
    }

    public ExecutorService getWorkerThreadExecutorService() {
        if (this._ioStrategy == IoStrategy.SAME_THREAD) {
            return MoreExecutors.newDirectExecutorService();
        }
        if (this._workerThreadExecutionService != null) {
            return this._workerThreadExecutionService;
        }
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(this._serviceName + " (%d)").build();
        int threadPoolSize = this._workerThreadPoolSize != 0 ? this._workerThreadPoolSize : GrizzlyUtils.getDefaultWorkerPoolSize();
        return Executors.newFixedThreadPool(threadPoolSize, threadFactory);
    }

    public int getSelectorThreadPoolSize() {
        return this._selectorThreadPoolSize;
    }

    public int getWorkerThreadPoolSize() {
        return this._workerThreadPoolSize;
    }

    public boolean isClient() {
        return this._isClient;
    }

    public Map<OncRpcProgram, RpcDispatchable> getRpcServices() {
        return this._programs;
    }

    public SSLContext getSSLContext() {
        return this._sslContext;
    }

    public SSLParameters getSSLParameters() {
        return this._sslParams;
    }

    public MemoryAllocator getMemoryAllocator() {
        return this._allocator;
    }

    public OncRpcSvc build() {
        if (this._protocol == 0 || (this._protocol & 6) != 6 && (this._protocol & 0x11) != 17) {
            throw new IllegalArgumentException("invalid protocol: " + this._protocol);
        }
        if (this._isClient && this._protocol == 23) {
            throw new IllegalArgumentException("Client mode can't be TCP and UDP at the same time");
        }
        if (this._isClient && this._maxPort != this._minPort) {
            throw new IllegalArgumentException("Can't use port range in client mode");
        }
        if (this._workerThreadExecutionService != null && this._workerThreadPoolSize > 0) {
            throw new IllegalArgumentException("Can't set worker thread pool size with external execution service");
        }
        return new OncRpcSvc(this);
    }
}

