/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc;

import java.io.IOException;
import java.nio.ByteOrder;
import org.dcache.oncrpc4j.xdr.Xdr;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.BuffersBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class RpcMessageParserTCP
extends BaseFilter {
    public static final int RPC_LAST_FRAG = Integer.MIN_VALUE;
    public static final int RPC_SIZE_MASK = Integer.MAX_VALUE;

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer messageBuffer = (Buffer)ctx.getMessage();
        if (messageBuffer == null) {
            return ctx.getStopAction();
        }
        if (!this.isAllFragmentsArrived(messageBuffer)) {
            return ctx.getStopAction(messageBuffer);
        }
        ctx.setMessage(this.assembleXdr(messageBuffer, ctx.getMemoryManager()));
        Buffer reminder = messageBuffer.hasRemaining() ? messageBuffer.split(messageBuffer.position()) : null;
        return ctx.getInvokeAction(reminder);
    }

    private boolean isAllFragmentsArrived(Buffer messageBuffer) {
        Buffer buffer = messageBuffer.duplicate();
        buffer.order(ByteOrder.BIG_ENDIAN);
        while (buffer.remaining() >= 4) {
            int messageMarker = buffer.getInt();
            int size = RpcMessageParserTCP.getMessageSize(messageMarker);
            if (size > buffer.remaining()) {
                return false;
            }
            if (RpcMessageParserTCP.isLastFragment(messageMarker)) {
                return true;
            }
            buffer.position(buffer.position() + size);
        }
        return false;
    }

    private static int getMessageSize(int marker) {
        return marker & Integer.MAX_VALUE;
    }

    private static boolean isLastFragment(int marker) {
        return (marker & Integer.MIN_VALUE) != 0;
    }

    private Xdr assembleXdr(Buffer messageBuffer, MemoryManager memoryManager) {
        Buffer currentFragment;
        boolean messageComplete;
        BuffersBuffer multipleFragments = null;
        do {
            int messageMarker = messageBuffer.getInt();
            int size = RpcMessageParserTCP.getMessageSize(messageMarker);
            messageComplete = RpcMessageParserTCP.isLastFragment(messageMarker);
            int pos = messageBuffer.position();
            currentFragment = messageBuffer.slice(pos, pos + size);
            currentFragment.limit(size);
            messageBuffer.position(pos + size);
            if (!messageComplete & multipleFragments == null) {
                multipleFragments = BuffersBuffer.create(memoryManager);
            }
            if (multipleFragments == null) continue;
            multipleFragments.append(currentFragment);
        } while (!messageComplete);
        return new Xdr(multipleFragments == null ? currentFragment : multipleFragments, memoryManager);
    }
}

