/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.rpc.gss;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;

class JaasConfigGenerator {
    private static final FileAttribute<Set<PosixFilePermission>> OWNER_RW = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
    private static final String KRB5_DEBUG = System.getProperty("sun.security.krb5.debug", "false");
    private static final String JAAS_CONFIG_TEMPLATE = "com.sun.security.jgss.accept {\n  com.sun.security.auth.module.Krb5LoginModule required\n  debug=" + KRB5_DEBUG + "\n  principal=\"%s\"\n  doNotPrompt=true\n  useKeyTab=true\n  keyTab=\"%s\"\n  debug=false\n  isInitiator=false\n  storeKey=true;\n};";

    JaasConfigGenerator() {
    }

    public static String generateJaasConfig(String servicePrincipal, String keytab) throws IOException {
        Path jaasFile = Files.createTempFile("jaas", ".conf", OWNER_RW);
        jaasFile.toFile().deleteOnExit();
        String config = String.format(JAAS_CONFIG_TEMPLATE, servicePrincipal, keytab);
        Files.write(jaasFile, config.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return jaasFile.toAbsolutePath().toString();
    }
}

