/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.oncrpc4j.spring;

import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvcBuilder;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;
import org.dcache.oncrpc4j.rpc.gss.GssSessionManager;
import org.springframework.beans.factory.FactoryBean;

public class OncRpcSvcFactoryBean
implements FactoryBean<OncRpcSvcBuilder> {
    private final OncRpcSvcBuilder builder = new OncRpcSvcBuilder();

    @Override
    public OncRpcSvcBuilder getObject() throws Exception {
        return this.builder;
    }

    @Override
    public Class<? extends OncRpcSvcBuilder> getObjectType() {
        return OncRpcSvcBuilder.class;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public void setAutoPublish(boolean autopublish) {
        if (autopublish) {
            this.builder.withAutoPublish();
        } else {
            this.builder.withoutAutoPublish();
        }
    }

    public void setMaxPort(int maxPort) {
        this.builder.withMaxPort(maxPort);
    }

    public void setMinPort(int minPort) {
        this.builder.withMinPort(minPort);
    }

    public void setPort(int port) {
        this.builder.withPort(port);
    }

    public void setUseTCP(boolean useTCP) {
        if (useTCP) {
            this.builder.withTCP();
        }
    }

    public void setUseUDP(boolean useUDP) {
        if (useUDP) {
            this.builder.withUDP();
        }
    }

    public void setUseWorkerPool(boolean useWorkerPool) {
        if (useWorkerPool) {
            this.builder.withWorkerThreadIoStrategy();
        } else {
            this.builder.withSameThreadIoStrategy();
        }
    }

    public void setEnableJmx(boolean enable) {
        if (enable) {
            this.builder.withJMX();
        }
    }

    public void setGssSessionManager(GssSessionManager gssSessionManager) {
        this.builder.withGssSessionManager(gssSessionManager);
    }

    public void setWorkerThreadExecutionService(ExecutorService executorService) {
        this.builder.withWorkerThreadExecutionService(executorService);
    }

    public void setRpcServices(Map<OncRpcProgram, RpcDispatchable> services) {
        for (Map.Entry<OncRpcProgram, RpcDispatchable> program : services.entrySet()) {
            this.builder.withRpcService(program.getKey(), program.getValue());
        }
    }

    public void setServiceName(String serviceName) {
        this.builder.withServiceName(serviceName);
    }

    public void setSelectorThreadPoolSize(int poolSize) {
        this.builder.withSelectorThreadPoolSize(poolSize);
    }

    public void setWorkerThreadPoolSize(int poolSize) {
        this.builder.withWorkerThreadPoolSize(poolSize);
    }

    public void setSslContext(SSLContext sslContext) {
        this.builder.withSSLContext(sslContext);
    }

    public void setSslParameters(SSLParameters sslParameters) {
        this.builder.withSSLParameters(sslParameters);
    }

    @Beta
    public void setEnableStartTLS(boolean enable) {
        if (enable) {
            this.builder.withStartTLS();
        } else {
            this.builder.withoutStartTLS();
        }
    }
}

