/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import org.dcache.nfs.IoChannelCache;
import org.dcache.nfs.bep.DataServerBepServiceGrpc;
import org.dcache.nfs.bep.RemoveFileRequest;
import org.dcache.nfs.bep.RemoveFileResponse;
import org.dcache.nfs.bep.SetFileSizeRequest;
import org.dcache.nfs.bep.SetFileSizeResponse;
import org.dcache.nfs.vfs.Inode;

public class BackendServer {
    private final IoChannelCache fs;
    private final Server server;

    public BackendServer(int port, IoChannelCache fs) throws IOException {
        this.fs = fs;
        this.server = ServerBuilder.forPort((int)port).addService((BindableService)new DataServerBepService()).build();
        this.server.start();
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private class DataServerBepService
    extends DataServerBepServiceGrpc.DataServerBepServiceImplBase {
        private DataServerBepService() {
        }

        @Override
        public void setFileSize(SetFileSizeRequest request, StreamObserver<SetFileSizeResponse> responseObserver) {
            long size = request.getSize();
            byte[] fh = request.getFh().toByteArray();
            int status = 0;
            try {
                BackendServer.this.fs.get(new Inode(fh)).setLength(size);
            }
            catch (IOException e) {
                status = 5;
            }
            SetFileSizeResponse reply = SetFileSizeResponse.newBuilder().setStatus(status).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }

        @Override
        public void removeFile(RemoveFileRequest request, StreamObserver<RemoveFileResponse> responseObserver) {
            byte[] fh = request.getFh().toByteArray();
            BackendServer.this.fs.remove(new Inode(fh));
            RemoveFileResponse reply = RemoveFileResponse.newBuilder().setStatus(0).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }
}

