/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.UUID;
import org.dcache.nfs.v4.xdr.deviceid4;
import org.dcache.oncrpc4j.util.Bytes;

public class Utils {
    private Utils() {
    }

    public static InetSocketAddress[] getLocalAddresses(int port) throws SocketException {
        ArrayList<InetSocketAddress> localaddresses = new ArrayList<InetSocketAddress>();
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            if (!iface.isUp() || iface.getName().startsWith("br-") || iface.isLoopback()) continue;
            Enumeration<InetAddress> addrs = iface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                localaddresses.add(new InetSocketAddress(addr, port));
            }
        }
        return localaddresses.toArray(new InetSocketAddress[0]);
    }

    public static deviceid4 deviceidOf(UUID id) {
        byte[] deviceidBytes = new byte[16];
        Bytes.putLong((byte[])deviceidBytes, (int)0, (long)id.getMostSignificantBits());
        Bytes.putLong((byte[])deviceidBytes, (int)8, (long)id.getLeastSignificantBits());
        return new deviceid4(deviceidBytes);
    }

    public static UUID uuidOf(deviceid4 id) {
        long high = Bytes.getLong((byte[])id.value, (int)0);
        long low = Bytes.getLong((byte[])id.value, (int)8);
        return new UUID(high, low);
    }
}

