/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.zk;

import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.dcache.nfs.Mirror;
import org.dcache.oncrpc4j.rpc.net.InetSocketAddresses;
import org.json.JSONArray;
import org.json.JSONObject;

public class ZkDataServer {
    public static byte[] toBytes(Mirror mirror) {
        JSONObject o = new JSONObject();
        o.put("version", (Object)"1.0");
        JSONArray a = new JSONArray();
        for (InetSocketAddress addr : mirror.getMultipath()) {
            a.put((Object)InetSocketAddresses.uaddrOf((InetSocketAddress)addr));
        }
        o.put("address", (Object)a);
        JSONArray b = new JSONArray();
        for (InetSocketAddress addr : mirror.getBepAddress()) {
            b.put((Object)InetSocketAddresses.uaddrOf((InetSocketAddress)addr));
        }
        o.put("bep", (Object)b);
        o.put("deviceid", (Object)mirror.getId().toString());
        return o.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static Mirror stringToString(byte[] bytes) {
        JSONObject o = new JSONObject(new String(bytes, StandardCharsets.UTF_8));
        JSONArray a = o.getJSONArray("address");
        JSONArray b = o.getJSONArray("bep");
        UUID id = UUID.fromString(o.getString("deviceid"));
        InetSocketAddress[] addrs = new InetSocketAddress[a.length()];
        for (int i = 0; i < addrs.length; ++i) {
            addrs[i] = InetSocketAddresses.forUaddrString((String)a.getString(i));
        }
        InetSocketAddress[] bep = new InetSocketAddress[b.length()];
        for (int i = 0; i < bep.length; ++i) {
            bep[i] = InetSocketAddresses.forUaddrString((String)b.getString(i));
        }
        return new Mirror(id, addrs, bep);
    }
}

