/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoChannelCache {
    private static final Logger _log = LoggerFactory.getLogger(IoChannelCache.class);
    private LoadingCache<Inode, RandomAccessFile> _cache;
    private int _maxSize;
    private int _lastAccess;
    private File _base;

    public void setBase(File base) {
        this._base = base;
    }

    public void setMaxSize(int maxSize) {
        this._maxSize = maxSize;
    }

    public void setLastAccess(int timeInSec) {
        this._lastAccess = timeInSec;
    }

    public void init() {
        this._cache = CacheBuilder.newBuilder().maximumSize((long)this._maxSize).expireAfterAccess((long)this._lastAccess, TimeUnit.SECONDS).removalListener((RemovalListener)new InodeGarbageCollector()).build((CacheLoader)new FileChannelSupplier(this._base));
    }

    public RandomAccessFile get(Inode inode) {
        return (RandomAccessFile)this._cache.getUnchecked((Object)inode);
    }

    public void remove(Inode inode) {
        this._cache.invalidate((Object)inode);
        File f = IoChannelCache.getLocalFile(this._base, inode);
        f.delete();
    }

    private static File getLocalFile(File base, Inode inode) {
        byte[] fid = inode.getFileId();
        String id = BaseEncoding.base16().lowerCase().encode(fid);
        int len = id.length();
        String topLevelDir = id.substring(len - 6, len - 4);
        String subDir = id.substring(len - 4, len - 2);
        File dir = new File(base, topLevelDir + "/" + subDir);
        return new File(dir, id);
    }

    private static class InodeGarbageCollector
    implements RemovalListener<Inode, RandomAccessFile> {
        private InodeGarbageCollector() {
        }

        public void onRemoval(RemovalNotification<Inode, RandomAccessFile> notification) {
            try {
                ((RandomAccessFile)notification.getValue()).close();
            }
            catch (IOException e) {
                _log.error("Failed to close file channel of {} : {}", notification.getKey(), (Object)e.getMessage());
            }
        }
    }

    private static class FileChannelSupplier
    extends CacheLoader<Inode, RandomAccessFile> {
        private final File _base;

        FileChannelSupplier(File base) {
            if (!base.isDirectory()) {
                throw new IllegalArgumentException(base + " : not exist or not a directory");
            }
            this._base = base;
        }

        public RandomAccessFile load(Inode inode) throws IOException {
            byte[] fid = inode.getFileId();
            String id = BaseEncoding.base16().lowerCase().encode(fid);
            File dir = this.getAndCreateDirectory(id);
            File f = new File(dir, id);
            return new RandomAccessFile(f, "rw");
        }

        private File getAndCreateDirectory(String id) {
            int len = id.length();
            String topLevelDir = id.substring(len - 6, len - 4);
            String subDir = id.substring(len - 4, len - 2);
            File dir = new File(this._base, topLevelDir + "/" + subDir);
            dir.mkdirs();
            return dir;
        }
    }
}

