/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.helpers.ssl.SSLTrustManager;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.DirectoryCertChainValidator;
import eu.emi.security.authn.x509.impl.PEMCredential;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import org.springframework.beans.factory.FactoryBean;

public class SslContextFactoryBean
implements FactoryBean<SSLContext> {
    private String certFilePath;
    private String keyFilePath;
    private char[] keyFilePass;
    private String trustedCaBundle;

    public void setCertFilePath(String certFilePath) {
        this.certFilePath = certFilePath;
    }

    public void setKeyFilePath(String keyFilePath) {
        this.keyFilePath = keyFilePath;
    }

    public void setKeyFilePass(char[] keyFilePass) {
        this.keyFilePass = keyFilePass;
    }

    public void setTrustedCaBundle(String trustedCaBundle) {
        this.trustedCaBundle = trustedCaBundle;
    }

    public SSLContext getObject() throws Exception {
        DirectoryCertChainValidator certificateValidator = new DirectoryCertChainValidator(Collections.singletonList(this.trustedCaBundle), CertificateUtils.Encoding.PEM, -1L, 5000, null);
        PEMCredential serviceCredentials = new PEMCredential(this.keyFilePath, this.certFilePath, this.keyFilePass);
        X509ExtendedKeyManager keyManager = serviceCredentials.getKeyManager();
        KeyManager[] kms = new KeyManager[]{keyManager};
        SSLTrustManager tm = new SSLTrustManager((X509CertChainValidator)certificateValidator);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(kms, new TrustManager[]{tm}, null);
        return ctx;
    }

    public Class<?> getObjectType() {
        return SSLContext.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

