/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jmx.JmxReporter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.OperationExecutor;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_opnum4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.oncrpc4j.rpc.OncRpcException;

public class MetricAwareOperationExecutor
implements OperationExecutor {
    private final OperationExecutor inner;
    private final MetricRegistry metrics;
    private final JmxReporter reporter;

    public MetricAwareOperationExecutor(OperationExecutor inner) {
        this.inner = inner;
        this.metrics = new MetricRegistry();
        this.reporter = JmxReporter.forRegistry((MetricRegistry)this.metrics).convertDurationsTo(TimeUnit.MICROSECONDS).convertRatesTo(TimeUnit.SECONDS).inDomain(OperationExecutor.class.getPackageName()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nfs_resop4 execute(CompoundContext context, nfs_argop4 arg) throws IOException, OncRpcException {
        Timer requests = this.metrics.timer(nfs_opnum4.toString((int)arg.argop));
        Timer.Context time = requests.time();
        try {
            nfs_resop4 nfs_resop42 = this.inner.execute(context, arg);
            return nfs_resop42;
        }
        finally {
            time.stop();
        }
    }

    public void start() {
        this.reporter.start();
    }

    public void shutdown() {
        this.reporter.stop();
    }
}

