/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.oncrpc4j.rpc.RpcLoginService;
import org.dcache.oncrpc4j.rpc.RpcTransport;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcGssLogin
implements RpcLoginService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcGssLogin.class);

    public Subject login(RpcTransport transport, GSSContext gssContext) {
        Subject s = new Subject();
        s.getPrincipals().add(new UnixNumericUserPrincipal(10006L));
        s.getPrincipals().add(new UnixNumericGroupPrincipal(1000L, true));
        try {
            s.getPrincipals().add(new KerberosPrincipal(gssContext.getSrcName().toString()));
        }
        catch (GSSException e) {
            LOGGER.warn("Failed to get source principal: ", (Object)e.getMessage());
        }
        return s;
    }
}

